/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\t)2i\u001c8tk6,'OR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003!\u0019wN\\:v[\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0005]\u0006lW\r\u0005\u0002\u001859\u0011q\u0002G\u0005\u00033A\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0004\u0005\u0005\t=\u0001\u0011)\u0019!C\u0001?\u000511m\u001c8gS\u001e,\u0012\u0001\t\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011abQ8ogVlWM]\"p]\u001aLw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0011\tqa\u00197vgR,'/\u0003\u0002.U\t1!I]8lKJD\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\u0005/E\u001a\u0014(\u0003\u000239\t\u0019Q*\u00199\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\"\u0011AB2p[6|g.\u0003\u00029k\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005\u0005R\u0014BA\u001e\u0003\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\t\u0011u\u0002!Q1A\u0005\u0002y\nacY8ogVlWM\u001d$fi\u000eDWM]'b]\u0006<WM]\u000b\u0002\u007fA\u0011\u0011\u0005Q\u0005\u0003\u0003\n\u0011acQ8ogVlWM\u001d$fi\u000eDWM]'b]\u0006<WM\u001d\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\u007f\u000592m\u001c8tk6,'OR3uG\",'/T1oC\u001e,'\u000f\t\u0005\u0006\u000b\u0002!\tAR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u001dC\u0015JS&M!\t\t\u0003\u0001C\u0003\u0016\t\u0002\u0007a\u0003C\u0003\u001f\t\u0002\u0007\u0001\u0005C\u0003(\t\u0002\u0007\u0001\u0006C\u00030\t\u0002\u0007\u0001\u0007C\u0003>\t\u0002\u0007q\bC\u0003O\u0001\u0011\u0005q*\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\u0005!N+&\f\u0005\u0002\u0010#&\u0011!\u000b\u0005\u0002\u0005+:LG\u000fC\u0003U\u001b\u0002\u00071'A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DQAV'A\u0002]\u000b1BZ3uG\"|eMZ:fiB\u0011q\u0002W\u0005\u00033B\u0011A\u0001T8oO\")1,\u0014a\u00019\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004\"!\u00181\u000e\u0003yS!a\u0018\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002b=\nQb)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\")1\r\u0001C\u0001I\u00061\u0002.\u00198eY\u0016|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0002XK\")AK\u0019a\u0001g!)q\r\u0001C\u0001Q\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR\u0011\u0001+\u001b\u0005\u0006U\u001a\u0004\ra[\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bc\u00017ug9\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a\u001a\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005M\u0004\u0012a\u00029bG.\fw-Z\u0005\u0003kZ\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003gB\u0001")
public class ConsumerFetcherThread
extends AbstractFetcherThread
implements ScalaObject {
    private final ConsumerConfig config;
    private final Map<TopicAndPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition, long fetchOffset, FetchResponsePartitionData partitionData) {
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply((Object)topicAndPartition);
        if (pti.getFetchOffset() != fetchOffset) {
            throw new RuntimeException(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition.topic(), BoxesRunTime.boxToInteger((int)topicAndPartition.partition()), BoxesRunTime.boxToLong((long)pti.getFetchOffset()), BoxesRunTime.boxToLong((long)fetchOffset)})));
        }
        pti.enqueue((ByteBufferMessageSet)partitionData.messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition) {
        long startTimestamp = 0L;
        String string = this.config().autoOffsetReset();
        String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            startTimestamp = OffsetRequest$.MODULE$.EarliestTime();
        } else {
            String string4 = OffsetRequest$.MODULE$.LargestTimeString();
            String string5 = string;
            startTimestamp = !(string4 != null ? !string4.equals(string5) : string5 != null) ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.LatestTime();
        }
        long newOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, startTimestamp, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply((Object)topicAndPartition);
        pti.resetFetchOffset(newOffset);
        pti.resetConsumeOffset(newOffset);
        return newOffset;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> partitions) {
        this.removePartitions((Set<TopicAndPartition>)partitions.toSet());
        this.consumerFetcherManager().addPartitionsWithError(partitions);
    }

    public ConsumerFetcherThread(String name, ConsumerConfig config, Broker sourceBroker, Map<TopicAndPartition, PartitionTopicInfo> partitionMap, ConsumerFetcherManager consumerFetcherManager) {
        this.config = config;
        this.partitionMap = partitionMap;
        this.consumerFetcherManager = consumerFetcherManager;
        super(name, config.clientId(), sourceBroker, config.socketTimeoutMs(), config.socketReceiveBufferBytes(), config.fetchMessageMaxBytes(), Request$.MODULE$.OrdinaryConsumerId(), config.fetchWaitMaxMs(), config.fetchMinBytes(), true);
    }
}

