/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponsePartitionData$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u000f\t\t\u0002+\u0019:uSRLwN\u001c#bi\u0006\u001cVM\u001c3\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\b]\u0016$xo\u001c:l\u0013\t)\"C\u0001\u0003TK:$\u0007CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aC*dC2\fwJ\u00196fGRD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001 !\t9\u0002%\u0003\u0002\"1\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\tA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\tI!A\u000b\u0002\u00035\u0019+Go\u00195SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u00111\u0002!\u0011!Q\u0001\n\u001d\na\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0005C\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0004aE\u0012\u0004C\u0001\u0015\u0001\u0011\u0015iR\u00061\u0001 \u0011\u0015)S\u00061\u0001(\u0011\u001d!\u0004A1A\u0005\ny\t1\"\\3tg\u0006<WmU5{K\"1a\u0007\u0001Q\u0001\n}\tA\"\\3tg\u0006<WmU5{K\u0002Bq\u0001\u000f\u0001A\u0002\u0013%a$\u0001\tnKN\u001c\u0018mZ3t'\u0016tGoU5{K\"9!\b\u0001a\u0001\n\u0013Y\u0014\u0001F7fgN\fw-Z:TK:$8+\u001b>f?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011q#P\u0005\u0003}a\u0011A!\u00168ji\"9\u0001)OA\u0001\u0002\u0004y\u0012a\u0001=%c!1!\t\u0001Q!\n}\t\u0011#\\3tg\u0006<Wm]*f]R\u001c\u0016N_3!\u0011\u001d!\u0005A1A\u0005\n\u0015\u000baAY;gM\u0016\u0014X#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0011a\u00018j_&\u00111\n\u0013\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bBB'\u0001A\u0003%a)A\u0004ck\u001a4WM\u001d\u0011\t\u000b=\u0003A\u0011\t)\u0002\u0011\r|W\u000e\u001d7fi\u0016,\u0012!\u0015\t\u0003/IK!a\u0015\r\u0003\u000f\t{w\u000e\\3b]\")Q\u000b\u0001C!-\u00069qO]5uKR{GCA\u0010X\u0011\u0015AF\u000b1\u0001Z\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"AW/\u000e\u0003mS!\u0001\u0018%\u0002\u0011\rD\u0017M\u001c8fYNL!AX.\u0003)\u001d\u000bG\u000f[3sS:<')\u001f;f\u0007\"\fgN\\3m\u0001")
public class PartitionDataSend
implements Send,
ScalaObject {
    private final int partitionId;
    private final FetchResponsePartitionData partitionData;
    private final int messageSize;
    private int messagesSentSize;
    private final ByteBuffer buffer;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int partitionId() {
        return this.partitionId;
    }

    public FetchResponsePartitionData partitionData() {
        return this.partitionData;
    }

    private int messageSize() {
        return this.messageSize;
    }

    private int messagesSentSize() {
        return this.messagesSentSize;
    }

    private void messagesSentSize_$eq(int n) {
        this.messagesSentSize = n;
    }

    private ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public boolean complete() {
        return !this.buffer().hasRemaining() && this.messagesSentSize() >= this.messageSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeTo(GatheringByteChannel channel) {
        void var2_2;
        int written = 0;
        if (this.buffer().hasRemaining()) {
            written += channel.write(this.buffer());
        }
        if (!this.buffer().hasRemaining() && this.messagesSentSize() < this.messageSize()) {
            int bytesSent = this.partitionData().messages().writeTo(channel, this.messagesSentSize(), this.messageSize() - this.messagesSentSize());
            this.messagesSentSize_$eq(this.messagesSentSize() + bytesSent);
            written += bytesSent;
        }
        return (int)var2_2;
    }

    public PartitionDataSend(int partitionId, FetchResponsePartitionData partitionData) {
        this.partitionId = partitionId;
        this.partitionData = partitionData;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.messageSize = partitionData.messages().sizeInBytes();
        this.messagesSentSize = 0;
        this.buffer = ByteBuffer.allocate(4 + FetchResponsePartitionData$.MODULE$.headerSize());
        this.buffer().putInt(partitionId);
        this.buffer().putShort(partitionData.error());
        this.buffer().putLong(partitionData.hw());
        this.buffer().putInt(partitionData.messages().sizeInBytes());
        this.buffer().rewind();
    }
}

