/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadata$;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping$;
import kafka.common.LeaderNotAvailableException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.ReplicaNotAvailableException$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.log.LogConfig$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdminUtils$
implements Logging,
ScalaObject {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String TopicConfigChangeZnodePrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new AdminUtils$();
    }

    public Random rand() {
        return this.rand;
    }

    public String TopicConfigChangeZnodePrefix() {
        return this.TopicConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<Object> brokerList$1, int nPartitions, int replicationFactor$1, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new AdminOperationException("number of partitions must be larger than 0");
        }
        if (replicationFactor$1 <= 0) {
            throw new AdminOperationException("replication factor must be larger than 0");
        }
        if (replicationFactor$1 > brokerList$1.size()) {
            throw new AdminOperationException(new StringBuilder().append((Object)"replication factor: ").append((Object)BoxesRunTime.boxToInteger((int)replicationFactor$1)).append((Object)" larger than available brokers: ").append((Object)BoxesRunTime.boxToInteger((int)brokerList$1.size())).toString());
        }
        HashMap ret$1 = new HashMap();
        int startIndex$1 = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerList$1.size());
        IntRef currentPartitionId$1 = new IntRef(startPartitionId >= 0 ? startPartitionId : 0);
        IntRef nextReplicaShift$1 = new IntRef(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerList$1.size()));
        Predef$.MODULE$.intWrapper(0).until(nPartitions).foreach$mVc$sp((Function1)new Serializable(brokerList$1, replicationFactor$1, ret$1, startIndex$1, currentPartitionId$1, nextReplicaShift$1){
            public static final long serialVersionUID;
            public final Seq brokerList$1;
            private final int replicationFactor$1;
            private final HashMap ret$1;
            private final int startIndex$1;
            private final IntRef currentPartitionId$1;
            public final IntRef nextReplicaShift$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                if (this.currentPartitionId$1.elem > 0 && this.currentPartitionId$1.elem % this.brokerList$1.size() == 0) {
                    ++this.nextReplicaShift$1.elem;
                }
                int firstReplicaIndex$1 = (this.currentPartitionId$1.elem + this.startIndex$1) % this.brokerList$1.size();
                ObjectRef replicaList$1 = new ObjectRef((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)this.brokerList$1.apply(firstReplicaIndex$1))})));
                Predef$.MODULE$.intWrapper(0).until(this.replicationFactor$1 - 1).foreach$mVc$sp((Function1)new Serializable(this, firstReplicaIndex$1, replicaList$1){
                    public static final long serialVersionUID;
                    private final anonfun.assignReplicasToBrokers.1 $outer;
                    private final int firstReplicaIndex$1;
                    private final ObjectRef replicaList$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int v1) {
                        this.replicaList$1.elem = ((List)this.replicaList$1.elem).$colon$colon(this.$outer.brokerList$1.apply(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$1, this.$outer.nextReplicaShift$1.elem, v1, this.$outer.brokerList$1.size())));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$1 = n;
                        this.replicaList$1 = objectRef;
                    }
                });
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)this.currentPartitionId$1.elem), (Object)((List)replicaList$1.elem).reverse());
                ++this.currentPartitionId$1.elem;
            }
            {
                this.brokerList$1 = seq;
                this.replicationFactor$1 = n;
                this.ret$1 = hashMap;
                this.startIndex$1 = n2;
                this.currentPartitionId$1 = intRef;
                this.nextReplicaShift$1 = intRef2;
            }
        });
        return ret$1.toMap(Predef$.MODULE$.conforms());
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public void addPartitions(ZkClient zkClient, String topic$1, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable, Properties config) {
        existingPartitionsReplicaList = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})));
        if (existingPartitionsReplicaList.size() == 0) {
            throw new AdminOperationException(Predef$.MODULE$.augmentString("The topic %s does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1})));
        }
        existingReplicaList$1 = (Seq)((Tuple2)existingPartitionsReplicaList.head())._2();
        partitionsToAdd = numPartitions - existingPartitionsReplicaList.size();
        if (partitionsToAdd <= 0) {
            throw new AdminOperationException("The number of partitions for a topic can only be increased");
        }
        brokerList = ZkUtils$.MODULE$.getSortedBrokerList(zkClient);
        if (replicaAssignmentStr == null) ** GOTO lbl-1000
        v0 = replicaAssignmentStr;
        var12_11 = "";
        if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) lbl-1000:
        // 2 sources

        {
            v1 = this.assignReplicasToBrokers(brokerList, partitionsToAdd, existingReplicaList$1.size(), BoxesRunTime.unboxToInt((Object)existingReplicaList$1.head()), existingPartitionsReplicaList.size());
        } else {
            v1 = this.getManualReplicaAssignment(replicaAssignmentStr, (Set<Object>)brokerList.toSet(), existingPartitionsReplicaList.size(), checkBrokerAvailable);
        }
        newPartitionReplicaList$1 = v1;
        unmatchedRepFactorList = (Iterable)newPartitionReplicaList$1.values().filter((Function1)new Serializable(existingReplicaList$1){
            public static final long serialVersionUID;
            private final Seq existingReplicaList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Seq<Object> p) {
                return p.size() != this.existingReplicaList$1.size();
            }
            {
                this.existingReplicaList$1 = seq;
            }
        });
        if (unmatchedRepFactorList.size() != 0) {
            throw new AdminOperationException(new StringBuilder().append((Object)"The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic ").append((Object)BoxesRunTime.boxToInteger((int)existingReplicaList$1.size())).toString());
        }
        this.info((Function0<String>)new Serializable(topic$1, newPartitionReplicaList$1){
            public static final long serialVersionUID;
            private final String topic$1;
            private final Map newPartitionReplicaList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Add partition list for %s is %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.newPartitionReplicaList$1}));
            }
            {
                this.topic$1 = string;
                this.newPartitionReplicaList$1 = map;
            }
        });
        partitionReplicaList = (scala.collection.mutable.Map)existingPartitionsReplicaList.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((TopicAndPartition)p._1()).partition())).$minus$greater(p._2());
            }
        }, Map$.MODULE$.canBuildFrom());
        partitionReplicaList.$plus$plus$eq(newPartitionReplicaList$1);
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic$1, (Map<Object, Seq<Object>>)partitionReplicaList, config, true);
    }

    public Properties addPartitions$default$6() {
        return new Properties();
    }

    public boolean addPartitions$default$5() {
        return true;
    }

    public String addPartitions$default$4() {
        return "";
    }

    public int addPartitions$default$3() {
        return 1;
    }

    public Map<Object, List<Object>> getManualReplicaAssignment(String replicaAssignmentList, Set<Object> availableBrokerList$1, int startPartitionId$1, boolean checkBrokerAvailable$1) {
        ObjectRef partitionList$1 = new ObjectRef((Object)replicaAssignmentList.split(","));
        HashMap ret$2 = new HashMap();
        IntRef partitionId$1 = new IntRef(startPartitionId$1);
        partitionList$1.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)).takeRight(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)).size() - partitionId$1.elem);
        Predef$.MODULE$.intWrapper(0).until(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList$1.elem)).size()).foreach$mVc$sp((Function1)new Serializable(availableBrokerList$1, startPartitionId$1, checkBrokerAvailable$1, partitionList$1, ret$2, partitionId$1){
            public static final long serialVersionUID;
            private final Set availableBrokerList$1;
            private final int startPartitionId$1;
            private final boolean checkBrokerAvailable$1;
            private final ObjectRef partitionList$1;
            private final HashMap ret$2;
            private final IntRef partitionId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.partitionList$1.elem)[v1].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(String s) {
                        return Predef$.MODULE$.augmentString(s.trim()).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()));
                if (Predef$.MODULE$.intArrayOps(brokerList).size() <= 0) {
                    throw new AdminOperationException("replication factor must be larger than 0");
                }
                if (Predef$.MODULE$.intArrayOps(brokerList).size() != Predef$.MODULE$.intArrayOps(brokerList).toSet().size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"duplicate brokers in replica assignment: ").append((Object)brokerList).toString());
                }
                if (this.checkBrokerAvailable$1 && !Predef$.MODULE$.intArrayOps(brokerList).toSet().subsetOf((GenSet)this.availableBrokerList$1)) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"some specified brokers not available. specified brokers: ").append((Object)brokerList.toString()).append((Object)"available broker:").append((Object)this.availableBrokerList$1.toString()).toString());
                }
                this.ret$2.put((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1.elem), (Object)Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$2.apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1.elem))).size() != ((SeqLike)this.ret$2.apply((Object)BoxesRunTime.boxToInteger((int)this.startPartitionId$1))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"partition ").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)" has different replication factor: ").append((Object)brokerList).toString());
                }
                ++this.partitionId$1.elem;
            }
            {
                this.availableBrokerList$1 = set;
                this.startPartitionId$1 = n;
                this.checkBrokerAvailable$1 = bl;
                this.partitionList$1 = objectRef;
                this.ret$2 = hashMap;
                this.partitionId$1 = intRef;
            }
        });
        return ret$2.toMap(Predef$.MODULE$.conforms());
    }

    public boolean getManualReplicaAssignment$default$4() {
        return true;
    }

    public void deleteTopic(ZkClient zkClient, String topic) {
        ZkUtils$.MODULE$.createPersistentPath(zkClient, ZkUtils$.MODULE$.getDeleteTopicPath(topic), ZkUtils$.MODULE$.createPersistentPath$default$3());
    }

    public boolean topicExists(ZkClient zkClient, String topic) {
        return zkClient.exists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public void createTopic(ZkClient zkClient, String topic, int partitions, int replicationFactor, Properties topicConfig) {
        Seq<Object> brokerList = ZkUtils$.MODULE$.getSortedBrokerList(zkClient);
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerList, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment$1, Properties config, boolean update) {
        Topic$.MODULE$.validate(topic);
        LogConfig$.MODULE$.validate(config);
        Predef$.MODULE$.require(((TraversableOnce)partitionReplicaAssignment$1.values().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Seq<Object> seq) {
                return seq.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() == 1, (Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "All partitions should have the same number of replicas.";
            }
        });
        String topicPath = ZkUtils$.MODULE$.getTopicPath(topic);
        if (!update && zkClient.exists(topicPath)) {
            throw new TopicExistsException(Predef$.MODULE$.augmentString("Topic \"%s\" already exists.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        partitionReplicaAssignment$1.values().foreach((Function1)new Serializable(partitionReplicaAssignment$1){
            public static final long serialVersionUID;
            public final Map partitionReplicaAssignment$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Seq<Object> reps) {
                Predef$.MODULE$.require(reps.size() == reps.toSet().size(), (Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.createOrUpdateTopicPartitionAssignmentPathInZK.3 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Duplicate replica assignment found: ").append((Object)this.$outer.partitionReplicaAssignment$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.partitionReplicaAssignment$1 = map;
            }
        });
        this.writeTopicConfig(zkClient, topic, config);
        this.writeTopicPartitionAssignment(zkClient, topic, partitionReplicaAssignment$1, update);
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    private void writeTopicPartitionAssignment(ZkClient zkClient, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update) {
        try {
            String zkPath$1 = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData$1 = ZkUtils$.MODULE$.replicaAssignmentZkData((Map<String, Seq<Object>>)((Map)replicaAssignment.map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> e) {
                    return Predef$.MODULE$.any2ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)e._1$mcI$sp())).toString()).$minus$greater(e._2());
                }
            }, scala.collection.Map$.MODULE$.canBuildFrom())));
            if (update) {
                this.info((Function0<String>)new Serializable(jsonPartitionData$1){
                    public static final long serialVersionUID;
                    private final String jsonPartitionData$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic update ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = string;
                    }
                });
                ZkUtils$.MODULE$.updatePersistentPath(zkClient, zkPath$1, jsonPartitionData$1);
            } else {
                this.info((Function0<String>)new Serializable(jsonPartitionData$1){
                    public static final long serialVersionUID;
                    private final String jsonPartitionData$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic creation ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = string;
                    }
                });
                ZkUtils$.MODULE$.createPersistentPath(zkClient, zkPath$1, jsonPartitionData$1);
            }
            this.debug((Function0<String>)new Serializable(zkPath$1, jsonPartitionData$1){
                public static final long serialVersionUID;
                private final String zkPath$1;
                private final String jsonPartitionData$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkPath$1, this.jsonPartitionData$1}));
                }
                {
                    this.zkPath$1 = string;
                    this.jsonPartitionData$1 = string2;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(Predef$.MODULE$.augmentString("topic %s already exists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public void changeTopicConfig(ZkClient zkClient, String topic, Properties configs) {
        if (this.topicExists(zkClient, topic)) {
            LogConfig$.MODULE$.validate(configs);
            this.writeTopicConfig(zkClient, topic, configs);
            zkClient.createPersistentSequential(new StringBuilder().append((Object)ZkUtils$.MODULE$.TopicConfigChangesPath()).append((Object)"/").append((Object)this.TopicConfigChangeZnodePrefix()).toString(), (Object)Json$.MODULE$.encode(topic));
            return;
        }
        throw new AdminOperationException(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
    }

    private void writeTopicConfig(ZkClient zkClient, String topic, Properties config) {
        scala.collection.mutable.Map configMap = JavaConversions$.MODULE$.propertiesAsScalaMap(config);
        Map map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"config").$minus$greater((Object)configMap)}));
        ZkUtils$.MODULE$.updatePersistentPath(zkClient, ZkUtils$.MODULE$.getTopicConfigPath(topic), Json$.MODULE$.encode(map));
    }

    public Properties fetchTopicConfig(ZkClient zkClient, String topic) {
        String str;
        block3: {
            block4: {
                Properties props$1;
                block2: {
                    Some some;
                    Object object;
                    Some some2;
                    Object object2;
                    str = (String)zkClient.readData(ZkUtils$.MODULE$.getTopicConfigPath(topic), true);
                    props$1 = new Properties();
                    if (str == null) break block2;
                    Option<Object> option = Json$.MODULE$.parseFull(str);
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (!(none$ == null ? option2 != null : !none$.equals(option2))) break block2;
                    if (!(option instanceof Some) || !((object2 = (some2 = (Some)option).x()) instanceof Map)) break block3;
                    Map map = (Map)object2;
                    Map map2 = map;
                    Predef$.MODULE$.require(BoxesRunTime.equals((Object)map2.apply((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)));
                    Option option3 = map2.get((Object)"config");
                    if (!(option3 instanceof Some) || !((object = (some = (Some)option3).x()) instanceof Map)) break block4;
                    ((IterableLike)((Map)object).filter((Function1)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Tuple2<String, String> tuple2) {
                            Tuple2<String, String> tuple22 = tuple2;
                            return tuple22 != null;
                        }
                    })).foreach((Function1)new Serializable(props$1){
                        public static final long serialVersionUID;
                        private final Properties props$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Object apply(Tuple2<String, String> tuple2) {
                            Tuple2<String, String> tuple22 = tuple2;
                            if (tuple22 != null) {
                                return this.props$1.setProperty((String)tuple22._1(), (String)tuple22._2());
                            }
                            throw new MatchError(tuple22);
                        }
                        {
                            this.props$1 = properties;
                        }
                    });
                }
                return props$1;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid topic config: ").append((Object)str).toString());
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unexpected value in config: ").append((Object)str).toString());
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkClient zkClient$1) {
        return ((TraversableOnce)ZkUtils$.MODULE$.getAllTopics(zkClient$1).map((Function1)new Serializable(zkClient$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2((Object)topic, (Object)AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient$1, topic));
            }
            {
                this.zkClient$1 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public TopicMetadata fetchTopicMetadataFromZk(String topic, ZkClient zkClient) {
        return this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, zkClient, (HashMap<Object, Broker>)new HashMap());
    }

    public Set<TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkClient zkClient$3) {
        HashMap cachedBrokerInfo$2 = new HashMap();
        return (Set)topics.map((Function1)new Serializable(zkClient$3, cachedBrokerInfo$2){
            public static final long serialVersionUID;
            private final ZkClient zkClient$3;
            private final HashMap cachedBrokerInfo$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TopicMetadata apply(String topic) {
                return AdminUtils$.MODULE$.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, this.zkClient$3, (HashMap<Object, Broker>)this.cachedBrokerInfo$2);
            }
            {
                this.zkClient$3 = zkClient;
                this.cachedBrokerInfo$2 = hashMap;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public final TopicMetadata kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(String topic$2, ZkClient zkClient$2, HashMap<Object, Broker> cachedBrokerInfo$1) {
        TopicMetadata topicMetadata;
        if (ZkUtils$.MODULE$.pathExists(zkClient$2, ZkUtils$.MODULE$.getTopicPath(topic$2))) {
            Map topicPartitionAssignment = (Map)ZkUtils$.MODULE$.getPartitionAssignmentForTopics(zkClient$2, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$2}))).get((Object)topic$2).get();
            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                }
            });
            List partitionMetadata = (List)sortedPartitions.map((Function1)new Serializable(topic$2, zkClient$2, cachedBrokerInfo$1){
                public static final long serialVersionUID;
                public final String topic$2;
                private final ZkClient zkClient$2;
                private final HashMap cachedBrokerInfo$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Loose catch block
                 */
                public final PartitionMetadata apply(Tuple2<Object, Seq<Object>> partitionMap) {
                    PartitionMetadata exceptionResult1;
                    block10: {
                        int partition$1 = partitionMap._1$mcI$sp();
                        Seq replicas$1 = (Seq)partitionMap._2();
                        Seq<Object> inSyncReplicas$1 = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.zkClient$2, this.topic$2, partition$1);
                        Option<Object> leader$1 = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient$2, this.topic$2, partition$1);
                        AdminUtils$.MODULE$.debug((Function0<String>)new Serializable(this, replicas$1, inSyncReplicas$1, leader$1){
                            public static final long serialVersionUID;
                            private final Seq replicas$1;
                            private final Seq inSyncReplicas$1;
                            private final Option leader$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"replicas = ").append((Object)this.replicas$1).append((Object)", in sync replicas = ").append((Object)this.inSyncReplicas$1).append((Object)", leader = ").append((Object)this.leader$1).toString();
                            }
                            {
                                this.replicas$1 = seq;
                                this.inSyncReplicas$1 = seq2;
                                this.leader$1 = option;
                            }
                        });
                        None$ leaderInfo = None$.MODULE$;
                        ObjectRef replicaInfo$1 = new ObjectRef((Object)Nil$.MODULE$);
                        ObjectRef isrInfo$1 = new ObjectRef((Object)Nil$.MODULE$);
                        exceptionResult1 = null;
                        try {
                            Option<Object> option = leader$1;
                            if (option instanceof Some) {
                                Some exceptionResult2 = null;
                                exceptionResult2 = new Some(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkClient$2, (scala.collection.mutable.Map<Object, Broker>)this.cachedBrokerInfo$1, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)((Some)option).x())}))).head());
                                leaderInfo = exceptionResult2;
                                replicaInfo$1.elem = AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkClient$2, (scala.collection.mutable.Map<Object, Broker>)this.cachedBrokerInfo$1, (Seq<Object>)((Seq)replicas$1.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final int apply(int id) {
                                        return this.apply$mcII$sp(id);
                                    }

                                    public int apply$mcII$sp(int v1) {
                                        return v1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom())));
                                isrInfo$1.elem = AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkClient$2, (scala.collection.mutable.Map<Object, Broker>)this.cachedBrokerInfo$1, inSyncReplicas$1);
                                if (((Seq)replicaInfo$1.elem).size() < replicas$1.size()) {
                                    throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"Replica information not available for following brokers: ").append((Object)((TraversableOnce)replicas$1.filterNot((Function1)new Serializable(this, replicaInfo$1){
                                        public static final long serialVersionUID;
                                        private final ObjectRef replicaInfo$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(int n) {
                                            return this.apply$mcZI$sp(n);
                                        }

                                        public boolean apply$mcZI$sp(int v1) {
                                            return ((SeqLike)((Seq)this.replicaInfo$1.elem).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final int apply(Broker broker) {
                                                    return broker.id();
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)v1));
                                        }
                                        {
                                            this.replicaInfo$1 = objectRef;
                                        }
                                    })).mkString(",")).toString());
                                }
                                if (((Seq)isrInfo$1.elem).size() < inSyncReplicas$1.size()) {
                                    throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"In Sync Replica information not available for following brokers: ").append((Object)((TraversableOnce)inSyncReplicas$1.filterNot((Function1)new Serializable(this, isrInfo$1){
                                        public static final long serialVersionUID;
                                        private final ObjectRef isrInfo$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(int n) {
                                            return this.apply$mcZI$sp(n);
                                        }

                                        public boolean apply$mcZI$sp(int v1) {
                                            return ((SeqLike)((Seq)this.isrInfo$1.elem).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final int apply(Broker broker) {
                                                    return broker.id();
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)v1));
                                        }
                                        {
                                            this.isrInfo$1 = objectRef;
                                        }
                                    })).mkString(",")).toString());
                                }
                                exceptionResult1 = new PartitionMetadata(partition$1, (Option<Broker>)leaderInfo, (Seq<Broker>)((Seq)replicaInfo$1.elem), (Seq<Broker>)((Seq)isrInfo$1.elem), ErrorMapping$.MODULE$.NoError());
                                break block10;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Object> option2 = option;
                            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                                throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader exists for partition ").append((Object)BoxesRunTime.boxToInteger((int)partition$1)).toString());
                            }
                            throw new MatchError(option);
                            catch (Throwable throwable) {
                                throw new LeaderNotAvailableException(Predef$.MODULE$.augmentString("Leader not available for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, BoxesRunTime.boxToInteger((int)partition$1)})), throwable);
                            }
                            catch (Throwable throwable) {
                                throw new ReplicaNotAvailableException(throwable, ReplicaNotAvailableException$.MODULE$.init$default$2());
                            }
                        }
                        catch (Throwable throwable) {
                            AdminUtils$.MODULE$.debug((Function0<String>)new Serializable(this, partition$1){
                                public static final long serialVersionUID;
                                private final anonfun.6 $outer;
                                private final int partition$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Error while fetching metadata for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.partition$1 = n;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID;
                                private final Throwable e$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.e$1;
                                }
                                {
                                    this.e$1 = throwable;
                                }
                            });
                            exceptionResult1 = new PartitionMetadata(partition$1, (Option<Broker>)leaderInfo, (Seq<Broker>)((Seq)replicaInfo$1.elem), (Seq<Broker>)((Seq)isrInfo$1.elem), ErrorMapping$.MODULE$.codeFor(throwable.getClass()));
                        }
                    }
                    return exceptionResult1;
                }
                {
                    this.topic$2 = string;
                    this.zkClient$2 = zkClient;
                    this.cachedBrokerInfo$1 = hashMap;
                }
            }, List$.MODULE$.canBuildFrom());
            topicMetadata = new TopicMetadata(topic$2, (Seq<PartitionMetadata>)partitionMetadata, TopicMetadata$.MODULE$.init$default$3());
        } else {
            topicMetadata = new TopicMetadata(topic$2, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode());
        }
        return topicMetadata;
    }

    public final Seq<Broker> kafka$admin$AdminUtils$$getBrokerInfoFromCache(ZkClient zkClient$4, scala.collection.mutable.Map<Object, Broker> cachedBrokerInfo$3, Seq<Object> brokerIds) {
        ObjectRef failedBrokerIds$1 = new ObjectRef((Object)new ListBuffer());
        Seq brokerMetadata = (Seq)brokerIds.map((Function1)new Serializable(zkClient$4, cachedBrokerInfo$3, failedBrokerIds$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$4;
            private final scala.collection.mutable.Map cachedBrokerInfo$3;
            private final ObjectRef failedBrokerIds$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Broker> apply(int id) {
                Option option;
                block4: {
                    Option<Broker> option2;
                    block6: {
                        Some some;
                        block3: {
                            block5: {
                                Broker broker;
                                block2: {
                                    Option optionalBrokerInfo = this.cachedBrokerInfo$3.get((Object)BoxesRunTime.boxToInteger((int)id));
                                    option = optionalBrokerInfo;
                                    if (!(option instanceof Some)) break block2;
                                    some = new Some(((Some)option).x());
                                    break block3;
                                }
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                                option2 = ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$4, id);
                                if (!(option2 instanceof Some)) break block5;
                                Some some2 = (Some)option2;
                                Broker brokerInfo = broker = (Broker)some2.x();
                                this.cachedBrokerInfo$3.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)).$minus$greater((Object)brokerInfo));
                                some = new Some((Object)brokerInfo);
                                break block3;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Broker> option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                            ((ListBuffer)this.failedBrokerIds$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)id));
                            some = None$.MODULE$;
                        }
                        return some;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$4 = zkClient;
                this.cachedBrokerInfo$3 = map;
                this.failedBrokerIds$1 = objectRef;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)brokerMetadata.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Option<Broker> option) {
                return option.isDefined();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Broker apply(Option<Broker> option) {
                return (Broker)option.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public final int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.rand = new Random();
        this.TopicConfigChangeZnodePrefix = "config_change_";
    }
}

