/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.util.SnapshotReason;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rf\u0001\u0002\u001c8\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004X\u0001\u0001\u0006Ia\u0013\u0005\u00061\u0002!\t!\u0017\u0005\u0006Q\u0002!I!\u001b\u0005\n\u0003\u0013\u0001\u0011\u0013!C\u0005\u0003\u0017A\u0011\"!\t\u0001#\u0003%I!a\t\t\u0013\u0005\u001d\u0002!%A\u0005\n\u0005%\u0002\"CA\u0017\u0001E\u0005I\u0011BA\u0018\u0011\u0019\t\u0019\u0004\u0001C\u00013\"1\u0011Q\b\u0001\u0005\u0002e3a!!\u0011\u0001\u0001\u0005\r\u0003BB#\r\t\u0003\t)\u0005C\u0005\u0002L1\u0001\r\u0011\"\u0001\u0002N!I\u0011\u0011\f\u0007A\u0002\u0013\u0005\u00111\f\u0005\t\u0003Cb\u0001\u0015)\u0003\u0002P!I\u00111\r\u0007C\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003/c\u0001\u0015!\u0003\u0002h!I\u0011\u0011\u0014\u0007A\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003;c\u0001\u0019!C\u0001\u0003?Cq!a)\rA\u0003&A\u0010C\u0005\u0002&2\u0001\r\u0011\"\u0001\u0002\u001c\"I\u0011q\u0015\u0007A\u0002\u0013\u0005\u0011\u0011\u0016\u0005\b\u0003[c\u0001\u0015)\u0003}\u0011%\ty\u000b\u0004a\u0001\n\u0003\t\t\fC\u0005\u0002:2\u0001\r\u0011\"\u0001\u0002<\"A\u0011q\u0018\u0007!B\u0013\t\u0019\fC\u0005\u0002B2\u0001\r\u0011\"\u0001\u0002\u001c\"I\u00111\u0019\u0007A\u0002\u0013\u0005\u0011Q\u0019\u0005\b\u0003\u0013d\u0001\u0015)\u0003}\u0011\u001d\tY\r\u0004C!\u0003\u001b4a!!@\u0001\u0001\u0005}\bBB#!\t\u0003\u00119\u0001C\u0005\u0002L\u0001\u0002\r\u0011\"\u0001\u0002N!I\u0011\u0011\f\u0011A\u0002\u0013\u0005!1\u0002\u0005\t\u0003C\u0002\u0003\u0015)\u0003\u0002P!9!q\u0002\u0011\u0005B\tE\u0001b\u0002B\u0010A\u0011\u0005\u00131\u0014\u0005\n\u0005C\u0001!\u0019!C\u0005\u0005GA\u0001B!\r\u0001A\u0003%!Q\u0005\u0005\n\u0005g\u0001!\u0019!C\u0005\u0005GA\u0001B!\u000e\u0001A\u0003%!Q\u0005\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBaAa\u0013\u0001\t\u0003I\u0006B\u0002B(\u0001\u0011\u0005\u0011\f\u0003\u0004\u0003T\u0001!\t!\u0017\u0005\u0007\u0005/\u0002A\u0011A-\t\r\tm\u0003\u0001\"\u0001Z\u0011\u0019\u0011y\u0006\u0001C\u00013\"9!1\r\u0001\u0005\n\t\u0015\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0005i\u0011%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014H+Z:u\u0015\tA\u0014(\u0001\u0005nKR\fG-\u0019;b\u0015\tQ4(\u0001\u0004tKJ4XM\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011aN\u0001\u001c[\u0016$\u0018\rZ1uC2{\u0017\rZ5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0016\u0003-\u0003\"\u0001T+\u000e\u00035S!AT(\u0002\u000b\u0019\fW\u000f\u001c;\u000b\u0005i\u0002&B\u0001\u001fR\u0015\t\u00116+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0006\u0019qN]4\n\u0005Yk%\u0001E'pG.4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003qiW\r^1eCR\fGj\\1eS:<g)Y;mi\"\u000bg\u000e\u001a7fe\u0002\naB^3sS\u001aLhj\u001c$bk2$8\u000fF\u0001[!\t\u00015,\u0003\u0002]\u0003\n!QK\\5uQ\t!a\f\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u0006\u0019\u0011\r]5\u000b\u0005\r$\u0017a\u00026va&$XM\u001d\u0006\u0003KN\u000bQA[;oSRL!a\u001a1\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u00078fo\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$RA[7su~\u0004\"\u0001S6\n\u00051<$A\u0006\"s_.,'/T3uC\u0012\fG/\u0019'jgR,g.\u001a:\t\u000f9,\u0001\u0013!a\u0001_\u00069Q.\u001a;sS\u000e\u001c\bC\u0001%q\u0013\t\txGA\nCe>\\WM]*feZ,'/T3ue&\u001c7\u000fC\u0004t\u000bA\u0005\t\u0019\u0001;\u0002\u0017Mt\u0017\r]:i_R$XM\u001d\t\u0004\u0001V<\u0018B\u0001<B\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001\n_\u0005\u0003s^\u00121#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;uKJDqa_\u0003\u0011\u0002\u0003\u0007A0\u0001\rnCb\u0014\u0015\u0010^3t\u0005\u0016$x/Z3o':\f\u0007o\u001d5piN\u0004\"\u0001Q?\n\u0005y\f%\u0001\u0002'p]\u001eD\u0011\"!\u0001\u0006!\u0003\u0005\r!a\u0001\u0002\u0019\u0019\fW\u000f\u001c;IC:$G.\u001a:\u0011\u00071\u000b)!C\u0002\u0002\b5\u0013ABR1vYRD\u0015M\u001c3mKJ\f1E\\3x\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e)\u001aq.a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007B\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1E\\3x\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002&)\u001aA/a\u0004\u0002G9,wO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0006\u0016\u0004y\u0006=\u0011a\t8fo\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003cQC!a\u0001\u0002\u0010\u0005\u0011B/Z:u\u0007J,\u0017\r^3B]\u0012\u001cEn\\:fQ\rQ\u0011q\u0007\t\u0004?\u0006e\u0012bAA\u001eA\n!A+Z:u\u0003-!Xm\u001d;Qk\nd\u0017n\u001d5)\u0007-\t9DA\fN_\u000e\\W*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e;feN\u0019AbP<\u0015\u0005\u0005\u001d\u0003cAA%\u00195\t\u0001!A\u0003j[\u0006<W-\u0006\u0002\u0002PA!\u0011\u0011KA+\u001b\t\t\u0019FC\u0002\u0002LAKA!a\u0016\u0002T\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011\"[7bO\u0016|F%Z9\u0015\u0007i\u000bi\u0006C\u0005\u0002`=\t\t\u00111\u0001\u0002P\u0005\u0019\u0001\u0010J\u0019\u0002\r%l\u0017mZ3!\u0003\u001d1\u0017-\u001b7ve\u0016,\"!a\u001a\u0011\r\u0005%\u00141PA@\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014AB1u_6L7M\u0003\u0003\u0002r\u0005M\u0014AC2p]\u000e,(O]3oi*!\u0011QOA<\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0014\u0001\u00026bm\u0006LA!! \u0002l\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002\u0002\u0006Ee\u0002BAB\u0003\u001bsA!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013k\u0014A\u0002\u001fs_>$h(C\u0001C\u0013\r\ty)Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019*!&\u0003\u0013QC'o\\<bE2,'bAAH\u0003\u0006Aa-Y5mkJ,\u0007%\u0001\u000bbGRLg/Z*oCB\u001c\bn\u001c;PM\u001a\u001cX\r^\u000b\u0002y\u0006A\u0012m\u0019;jm\u0016\u001cf.\u00199tQ>$xJ\u001a4tKR|F%Z9\u0015\u0007i\u000b\t\u000b\u0003\u0005\u0002`Q\t\t\u00111\u0001}\u0003U\t7\r^5wKNs\u0017\r]:i_R|eMZ:fi\u0002\n1\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR\fq\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR|F%Z9\u0015\u0007i\u000bY\u000b\u0003\u0005\u0002`]\t\t\u00111\u0001}\u0003Q\u0001(/\u001a<D_6l\u0017\u000e\u001e;fI>3gm]3uA\u0005\u0011\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2i+\t\t\u0019\fE\u0002A\u0003kK1!a.B\u0005\rIe\u000e^\u0001\u0017aJ,goQ8n[&$H/\u001a3Fa>\u001c\u0007n\u0018\u0013fcR\u0019!,!0\t\u0013\u0005}#$!AA\u0002\u0005M\u0016a\u00059sKZ\u001cu.\\7jiR,G-\u00129pG\"\u0004\u0013\u0001\u00079sKZd\u0015m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\u0006a\u0002O]3w\u0019\u0006\u001cHoQ8oi\u0006Lg.\u001a3M_\u001e$\u0016.\\3`I\u0015\fHc\u0001.\u0002H\"A\u0011qL\u000f\u0002\u0002\u0003\u0007A0A\rqe\u00164H*Y:u\u0007>tG/Y5oK\u0012dun\u001a+j[\u0016\u0004\u0013AE7bs\n,7\u000b^1siNs\u0017\r]:i_R$\u0002\"a4\u0002V\u0006e\u0017Q\u001c\t\u0004\u0001\u0006E\u0017bAAj\u0003\n9!i\\8mK\u0006t\u0007BBAl?\u0001\u0007A0\u0001\u000bmCN$8i\u001c8uC&tW\r\u001a'pORKW.\u001a\u0005\b\u00037|\u0002\u0019AA(\u0003!qWm^%nC\u001e,\u0007bBAp?\u0001\u0007\u0011\u0011]\u0001\u0007e\u0016\f7o\u001c8\u0011\r\u0005\r\u00181^Ay\u001d\u0011\t)/a:\u0011\u0007\u0005\u0015\u0015)C\u0002\u0002j\u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAw\u0003_\u00141aU3u\u0015\r\tI/\u0011\t\u0005\u0003g\fI0\u0004\u0002\u0002v*!\u0011QOA|\u0015\tA\u0004+\u0003\u0003\u0002|\u0006U(AD*oCB\u001c\bn\u001c;SK\u0006\u001cxN\u001c\u0002\u0016\u001b>\u001c7.T3uC\u0012\fG/\u0019)vE2L7\u000f[3s'\u0011\u0001sH!\u0001\u0011\u0007!\u0013\u0019!C\u0002\u0003\u0006]\u0012\u0011#T3uC\u0012\fG/\u0019)vE2L7\u000f[3s)\t\u0011I\u0001E\u0002\u0002J\u0001\"2A\u0017B\u0007\u0011%\tyfIA\u0001\u0002\u0004\ty%A\u0004qk\nd\u0017n\u001d5\u0015\u000bi\u0013\u0019B!\b\t\u000f\tUQ\u00051\u0001\u0003\u0018\u0005)A-\u001a7uCB!\u0011\u0011\u000bB\r\u0013\u0011\u0011Y\"a\u0015\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b\u0011\u001d\tY.\na\u0001\u0003\u001f\nq\u0002];cY&\u001c\b.\u001a3PM\u001a\u001cX\r^\u0001\u0007\r>{u,\u0013#\u0016\u0005\t\u0015\u0002\u0003\u0002B\u0014\u0005[i!A!\u000b\u000b\u0007\t-\u0002+\u0001\u0004d_6lwN\\\u0005\u0005\u0005_\u0011IC\u0001\u0003Vk&$\u0017a\u0002$P\u001f~KE\tI\u0001\u0007\u0005\u0006\u0013v,\u0013#\u0002\u000f\t\u000b%kX%EA\u0005\u0019r-\u001a8fe\u0006$X-T1osJ+7m\u001c:egR)!La\u000f\u0003@!1!QH\u0016A\u0002)\f\u0001\u0002\\5ti\u0016tWM\u001d\u0005\u0007\u0005\u0003Z\u0003\u0019\u0001?\u0002\u0013\u0015tGm\u00144gg\u0016$\u0018AE4f]\u0016\u0014\u0018\r^3CC\u0012\u0014VmY8sIN$RA\u0017B$\u0005\u0013BaA!\u0010-\u0001\u0004Q\u0007B\u0002B!Y\u0001\u0007A0A\u0015uKN$\b*\u00198eY\u0016\u001cu.\\7jiN<\u0016\u000e\u001e5O_Ns\u0017\r]:i_R$XM\u001d#fM&tW\r\u001a\u0015\u0004[\u0005]\u0012A\u0005;fgR\u001c%/Z1uKNs\u0017\r]:i_RD3ALA\u001c\u0003e\"Xm\u001d;O_R\u001cf.\u00199tQ>$\u0018I\u001a;fe6+G/\u00193bi\u00064VM]:j_:\u001c\u0005.\u00198hK\n+gm\u001c:f!V\u0014G.[:iS:<\u0007fA\u0018\u00028\u0005\u0011D/Z:u':\f\u0007o\u001d5pi\u00063G/\u001a:NKR\fG-\u0019;b-\u0016\u00148/[8o\u0007\"\fgnZ3XQ\u0016t7\u000b^1si&tw\rK\u00021\u0003o\ta\u0005^3tiNs\u0017\r]:i_R\fe\r^3s\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u000eC\u0017M\\4fQ\r\t\u0014qG\u0001\u0019i\u0016\u001cHOT8T]\u0006\u00048\u000f[8u\u0003\u001a$XM]#se>\u0014\bf\u0001\u001a\u00028\u0005y!/Z4jgR,'O\u0011:pW\u0016\u00148\u000fF\u0004[\u0005O\u0012IGa\u001d\t\r\tu2\u00071\u0001k\u0011\u001d\u0011Yg\ra\u0001\u0005[\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\r\u0005\u0005%qNAZ\u0013\u0011\u0011\t(!&\u0003\u0011%#XM]1cY\u0016DaA!\u00114\u0001\u0004a\u0018aG2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5P]\u0016\u0004\u0016M\u001d;ji&|g\u000eF\u0004[\u0005s\u0012YH!\"\t\r\tuB\u00071\u0001k\u0011\u001d\u0011i\b\u000ea\u0001\u0005\u007f\n\u0001B]3qY&\u001c\u0017m\u001d\t\u0007\u0003\u0003\u0013\t)a-\n\t\t\r\u0015Q\u0013\u0002\u0004'\u0016\f\bB\u0002B!i\u0001\u0007A0A\u0007va\u0012\fG/\u001a$fCR,(/\u001a\u000b\n5\n-%Q\u0012BL\u0005CCaA!\u00106\u0001\u0004Q\u0007b\u0002BHk\u0001\u0007!\u0011S\u0001\bM\u0016\fG/\u001e:f!\u0011\t\u0019Oa%\n\t\tU\u0015q\u001e\u0002\u0007'R\u0014\u0018N\\4\t\u000f\teU\u00071\u0001\u0003\u001c\u00069a/\u001a:tS>t\u0007c\u0001!\u0003\u001e&\u0019!qT!\u0003\u000bMCwN\u001d;\t\r\t\u0005S\u00071\u0001}\u0001")
public class BrokerMetadataListenerTest {
    private final MockFaultHandler metadataLoadingFaultHandler = new MockFaultHandler("metadata loading");
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");
    private final Uuid BAR_ID = Uuid.fromString((String)"SzN5j0LvSEaRIJHrxfMAlg");

    private MockFaultHandler metadataLoadingFaultHandler() {
        return this.metadataLoadingFaultHandler;
    }

    @AfterEach
    public void verifyNoFaults() {
        this.metadataLoadingFaultHandler().maybeRethrowFirstException();
    }

    private BrokerMetadataListener newBrokerMetadataListener(BrokerServerMetrics metrics, Option<MetadataSnapshotter> snapshotter, long maxBytesBetweenSnapshots, FaultHandler faultHandler) {
        return new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, maxBytesBetweenSnapshots, snapshotter, metrics, faultHandler);
    }

    private BrokerServerMetrics newBrokerMetadataListener$default$1() {
        Metrics apply_metrics = new Metrics();
        return new BrokerServerMetrics(apply_metrics);
    }

    private Option<MetadataSnapshotter> newBrokerMetadataListener$default$2() {
        return None$.MODULE$;
    }

    private long newBrokerMetadataListener$default$3() {
        return 1000000L;
    }

    private FaultHandler newBrokerMetadataListener$default$4() {
        return this.metadataLoadingFaultHandler();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAndClose() {
        void newBrokerMetadataListener_faultHandler;
        void newBrokerMetadataListener_maxBytesBetweenSnapshots;
        FaultHandler faultHandler = this.newBrokerMetadataListener$default$4();
        long l = 1000000L;
        None$ newBrokerMetadataListener_snapshotter = None$.MODULE$;
        BrokerServerMetrics newBrokerMetadataListener_metrics = this.newBrokerMetadataListener$default$1();
        Object var1_4 = null;
        Object var2_3 = null;
        faultHandler = null;
        new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, (long)newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)newBrokerMetadataListener_snapshotter, newBrokerMetadataListener_metrics, (FaultHandler)newBrokerMetadataListener_faultHandler).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPublish() {
        void newBrokerMetadataListener_faultHandler;
        void newBrokerMetadataListener_maxBytesBetweenSnapshots;
        Metrics apply_metrics = new Metrics();
        Object var11_1 = null;
        BrokerServerMetrics metrics = new BrokerServerMetrics(apply_metrics);
        FaultHandler faultHandler = this.newBrokerMetadataListener$default$4();
        long l = 1000000L;
        None$ newBrokerMetadataListener_snapshotter = None$.MODULE$;
        Object var12_5 = null;
        faultHandler = null;
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, (long)newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)newBrokerMetadataListener_snapshotter, metrics, (FaultHandler)newBrokerMetadataListener_faultHandler);){
            long unfencedTimestamp = 300L;
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, (long)unfencedTimestamp, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0))));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)0, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)metrics.lastAppliedOffset());
            Assertions.assertEquals((long)-1L, (long)metrics.lastAppliedTimestamp());
            Assertions.assertEquals((long)0L, (long)metrics.metadataLoadErrorCount().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataApplyErrorCount().get());
            long fencedTimestamp = 500L;
            long fencedLastOffset = 200L;
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)fencedLastOffset, (long)fencedTimestamp, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0))));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newImage.highestOffsetAndEpoch().offset());
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false, false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true, false), (Object)delta.clusterDelta().broker(1));
                }

                public long publishedOffset() {
                    return -1L;
                }
            }).get();
            Assertions.assertEquals((long)fencedLastOffset, (long)metrics.lastAppliedOffset());
            Assertions.assertEquals((long)fencedTimestamp, (long)metrics.lastAppliedTimestamp());
            Assertions.assertEquals((long)0L, (long)metrics.metadataLoadErrorCount().get());
            Assertions.assertEquals((long)0L, (long)metrics.metadataApplyErrorCount().get());
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private Uuid BAR_ID() {
        return this.BAR_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)))));
        listener.getImageRecords().get();
    }

    private void generateBadRecords(BrokerMetadataListener listener, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.BAR_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.BAR_ID()).setRemovingReplicas(Collections.emptyList()), (short)0))));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        BrokerServerMetrics x$2 = this.newBrokerMetadataListener$default$1();
        None$ x$3 = None$.MODULE$;
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$3, x$2, x$4);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    @Test
    public void testCreateSnapshot() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    @Test
    public void testNotSnapshotAfterMetadataVersionChangeBeforePublishing() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        this.updateFeature(listener, "metadata.version", MetadataVersion.latest().featureLevel(), 100L);
        listener.getImageRecords().get();
        Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset(), (String)"We won't generate snapshot on metadata version change before starting publishing");
    }

    @Test
    public void testSnapshotAfterMetadataVersionChangeWhenStarting() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        long endOffset = 100L;
        this.updateFeature(listener, "metadata.version", MetadataVersion.latest().featureLevel(), endOffset);
        listener.startPublishing((MetadataPublisher)new MockMetadataPublisher()).get();
        Assertions.assertEquals((long)endOffset, (long)snapshotter.activeSnapshotOffset(), (String)"We should try to generate snapshot when starting publishing");
    }

    @Test
    public void testSnapshotAfterMetadataVersionChange() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$3 = this.newBrokerMetadataListener$default$1();
        FaultHandler x$4 = this.newBrokerMetadataListener$default$4();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$3, x$4);
        listener.startPublishing((MetadataPublisher)new MockMetadataPublisher()).get();
        long endOffset = 100L;
        this.updateFeature(listener, "metadata.version", (short)(MetadataVersion.latest().featureLevel() - 1), endOffset);
        listener.getImageRecords().get();
        Assertions.assertEquals((long)endOffset, (long)snapshotter.activeSnapshotOffset(), (String)"We should generate snapshot on feature update");
    }

    @Test
    public void testNoSnapshotAfterError() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        MockFaultHandler faultHandler = new MockFaultHandler("metadata loading");
        Some x$1 = new Some((Object)snapshotter);
        BrokerServerMetrics x$4 = this.newBrokerMetadataListener$default$1();
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$1, x$4, (FaultHandler)faultHandler);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
            this.generateBadRecords(listener, 1000L);
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 2000L);
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.activeSnapshotOffset());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, scala.collection.immutable.Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setLeader(0).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()), (short)0))));
    }

    private void updateFeature(BrokerMetadataListener listener, String feature, short version, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, (long)0L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(feature).setFeatureLevel(version), (short)0))));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public void publish(MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public long publishedOffset() {
            return -1L;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long lastContainedLogTime, MetadataImage newImage, Set<SnapshotReason> reason) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= newImage.highestOffsetAndEpoch().offset() ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= newImage.highestOffsetAndEpoch().epoch() ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(newImage.highestOffsetAndEpoch().offset());
                this.prevCommittedEpoch_$eq(newImage.highestOffsetAndEpoch().epoch());
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(newImage.highestOffsetAndEpoch().offset());
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

