/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u0012$\u0001!BQ!\f\u0001\u0005\u00029BQ\u0001\r\u0001\u0005BEBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001b\u0001\n\u0013q\u0005BB+\u0001A\u0003%q\nC\u0004W\u0001\t\u0007I\u0011\u0002(\t\r]\u0003\u0001\u0015!\u0003P\u0011\u001dA\u0006A1A\u0005\n9Ca!\u0017\u0001!\u0002\u0013y\u0005\"\u0002.\u0001\t\u0003Y\u0006\"B5\u0001\t\u0003Y\u0006\"B6\u0001\t\u0003Y\u0006\"B7\u0001\t\u0003Y\u0006\"B8\u0001\t\u0003Y\u0006\"B9\u0001\t\u0003Y\u0006\"B:\u0001\t\u0003Y\u0006\"B;\u0001\t\u0003Y\u0006\"B<\u0001\t\u0003Y\u0006\"B=\u0001\t\u0013Q\b\"CA\u0014\u0001E\u0005I\u0011BA\u0015\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003B\u0011\"a\u0015\u0001#\u0003%I!!\u000b\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!4\u0001\t\u0013\ty\rC\u0004\u0002f\u0002!I!a:\t\u000f\u00055\b\u0001\"\u0003\u0002p\n!\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002%K\u000511/\u001a:wKJT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+W5\t1%\u0003\u0002-G\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011!\u0006A\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006s\t\u0001\rAO\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011)H/\u001b7\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aE:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001cX#\u0001#\u0011\u0007M*u)\u0003\u0002Gi\t)\u0011I\u001d:bsB\u00111\u0007S\u0005\u0003\u0013R\u0012AAQ=uK\u0006!2/\u00197uK\u0012\u0004\u0016m]:x_J$')\u001f;fg\u0002\n\u0011b]1mi\nKH/Z:\u0002\u0015M\fG\u000e\u001e\"zi\u0016\u001c\b%A\u0003vg\u0016\u0014\u0018'F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011f(\u0001\u0003mC:<\u0017B\u0001+R\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013aC;oW:|wO\\+tKJ\fA\"\u001e8l]><h.V:fe\u0002\n\u0001\u0003^3ti\u0006cG/\u001a:O_RD\u0017N\\4\u0015\u0003IB#!D/\u0011\u0005y;W\"A0\u000b\u0005\u0001\f\u0017aA1qS*\u0011!mY\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!W-A\u0003kk:LGOC\u0001g\u0003\ry'oZ\u0005\u0003Q~\u0013A\u0001V3ti\u00069B/Z:u\u00032$XM]*b[\u0016$\u0006.\u001b8h)^L7-\u001a\u0015\u0003\u001du\u000b!\u0003^3ti\u0006cG/\u001a:F[B$\u00180V:fe\"\u0012q\"X\u0001\u001ai\u0016\u001cH/\u00117uKJ,fn\u001b8po:lUm\u00195b]&\u001cX\u000e\u000b\u0002\u0011;\u0006IB/Z:u\u00032$XM\u001d+p_\u001a+w/\u0013;fe\u0006$\u0018n\u001c8tQ\t\tR,\u0001\u000euKN$\u0018\t\u001c;feR{w.T1os&#XM]1uS>t7\u000f\u000b\u0002\u0013;\u0006\u0019C/Z:u\t\u0016dW\r^3T_6,G\u000f[5oORC\u0017\r\u001e#pKNtu\u000e^#ySN$\bFA\n^\u0003Y!Xm\u001d;BYR,'OT8u\u0007>tGO]8mY\u0016\u0014\bF\u0001\u000b^\u0003Q!Xm\u001d;BYR,'/\u00118e\t\u0016\u001c8M]5cK\"\u0012Q#X\u0001%g\u0016tG-\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR)10!\u0004\u0002\u0018A\u0019A0!\u0003\u000e\u0003uT!A`@\u0002\u0011I,\u0017/^3tiNTA!!\u0001\u0002\u0004\u000511m\\7n_:T1AJA\u0003\u0015\r\t9!Z\u0001\u0007CB\f7\r[3\n\u0007\u0005-QPA\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rC\u0004\u0002\u0010Y\u0001\r!!\u0005\u0002\u000fI,\u0017/^3tiB\u0019A0a\u0005\n\u0007\u0005UQP\u0001\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\b\"CA\r-A\u0005\t\u0019AA\u000e\u00031\u0019xnY6fiN+'O^3s!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011K\u00059a.\u001a;x_J\\\u0017\u0002BA\u0013\u0003?\u0011AbU8dW\u0016$8+\u001a:wKJ\faf]3oI\u0006cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0006\u0016\u0005\u00037\tic\u000b\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C;oG\",7m[3e\u0015\r\tI\u0004N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001f\u0003g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u001d\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\r\u0005\r\u0013\u0011JA)!\ra\u0018QI\u0005\u0004\u0003\u000fj(\u0001\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3\t\u000f\u0005=\u0001\u00041\u0001\u0002LA\u0019A0!\u0014\n\u0007\u0005=SPA\u0012EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\t\u0013\u0005e\u0001\u0004%AA\u0002\u0005m\u0011!M:f]\u0012$Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$C-\u001a4bk2$HEM\u0001\"G\",7m[!mY\u0016\u0013(o\u001c:t\u00032$XM]5oO\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\be\u0005e\u0013qRAP\u0011\u001d\tYF\u0007a\u0001\u0003;\naB]3tk2$8\u000fV8DQ\u0016\u001c7\u000eE\u0003<\u0003?\n\u0019'C\u0002\u0002bq\u0012A\u0001T5tiB!\u0011QMAE\u001d\u0011\t9'a!\u000f\t\u0005%\u0014q\u0010\b\u0005\u0003W\niH\u0004\u0003\u0002n\u0005md\u0002BA8\u0003srA!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k:\u0013A\u0002\u001fs_>$h(C\u0001g\u0013\r\t9!Z\u0005\u0004M\u0005\u0015\u0011\u0002BA\u0001\u0003\u0007I1!!!\u0000\u0003\u001diWm]:bO\u0016LA!!\"\u0002\b\u0006)\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0004\u0003\u0003{\u0018\u0002BAF\u0003\u001b\u0013q$\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7/\u001e7u\u0015\u0011\t))a\"\t\u000f\u0005E%\u00041\u0001\u0002\u0014\u0006iQ\r\u001f9fGR,G-\u0012:s_J\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033{\u0018\u0001\u00039s_R|7m\u001c7\n\t\u0005u\u0015q\u0013\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005\u0005&\u00041\u0001\u0002$\u0006Q1m\u001c8uKb$Xj]4\u0011\t\u0005\u0015\u0016Q\u0016\b\u0005\u0003O\u000bI\u000bE\u0002\u0002rQJ1!a+5\u0003\u0019\u0001&/\u001a3fM&\u0019A+a,\u000b\u0007\u0005-F'\u0001\u0011dQ\u0016\u001c7NT8FeJ|'o]!mi\u0016\u0014\u0018N\\4De\u0016$WM\u001c;jC2\u001cHc\u0001\u001a\u00026\"9\u00111L\u000eA\u0002\u0005u\u0013AH2iK\u000e\\Wk]3s\u0003B\u0004X-\u0019:t\u0013:\fE\u000e^3s%\u0016\u001cX\u000f\u001c;t)\u0015\u0011\u00141XA_\u0011\u001d\tY\u0006\ba\u0001\u0003;Bq!a0\u001d\u0001\u0004\t\u0019+\u0001\u0003vg\u0016\u0014\u0018a\n3fg\u000e\u0014\u0018NY3BY2<\u0016\u000e\u001e5O_R{\u0007\u000fT3wK2,%O]8s\u0007>tg-\u001b:nK\u0012$\"!a\u0011\u0002S\rDWmY6O_R{\u0007\u000fT3wK2,%O]8s\t\u0016\u001c8M]5cS:<7I]3eK:$\u0018.\u00197t)\r\u0011\u0014\u0011\u001a\u0005\b\u0003\u0017t\u0002\u0019AA\"\u0003=\u0011Xm\u001d9p]N,Gk\\\"iK\u000e\\\u0017AG2iK\u000e\\Wk]3s\u0011\u0006\u001cHk^8De\u0016$WM\u001c;jC2\u001cH#\u0002\u001a\u0002R\u0006\r\bbBA.?\u0001\u0007\u00111\u001b\t\u0006w\u0005}\u0013Q\u001b\t\u0005\u0003/\fiN\u0004\u0003\u0002h\u0005e\u0017\u0002BAn\u0003\u000f\u000b\u0001\u0006R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a#bi\u0006LA!a8\u0002b\n\u0011C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:vYRTA!a7\u0002\b\"9\u0011qX\u0010A\u0002\u0005\r\u0016\u0001L2iK\u000e\\gi\u001c:TS:<G.Z*iCV\n$'\u0013;fe\u0006$\u0018n\u001c8tqEJ$g\u0011:fI\u0016tG/[1m)\u0015\u0011\u0014\u0011^Av\u0011\u001d\tY\u0006\ta\u0001\u0003'Dq!a0!\u0001\u0004\t\u0019+A\u000bdQ\u0016\u001c7\u000eR3tGJL'-\u001a$pe\u0016\u0013(o\u001c:\u0015\u000fI\n\t0a=\u0002v\"9\u00111L\u0011A\u0002\u0005M\u0007bBA`C\u0001\u0007\u00111\u0015\u0005\b\u0003#\u000b\u0003\u0019AAJ\u0001")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String unknownUser;

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @Test
    public void testAlterNothing() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testAlterSameThingTwice() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion1)).setUpsertions(Arrays.asList(upsertion2, upsertion2))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion2)).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterEmptyUser() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty)).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty, deletionEmpty)).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterUnknownMechanism() {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user3 = "user3";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown3 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user3).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid3 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user3).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionUnknown1, deletionValid1, deletionUnknown2)).setUpsertions(Arrays.asList(upsertionUnknown3, upsertionValid3, upsertionUnknown4, upsertionUnknown5))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        CollectionConverters$.MODULE$.ListHasAsScala(results).asScala().foreach((Function1 & Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterTooFewIterations() {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @Test
    public void testAlterTooManyIterations() {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @Test
    public void testDeleteSomethingThatDoesNotExist() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    @Test
    public void testAlterAndDescribe() {
        AlterUserScramCredentialsRequest request1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        java.util.List results1 = this.sendAlterUserScramCredentialsRequest(request1, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results1.size());
        this.checkNoErrorsAlteringCredentials(results1);
        this.checkUserAppearsInAlterResults(results1, this.user1());
        this.checkUserAppearsInAlterResults(results1, this.user2());
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)1, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString());
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.controllerSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString());
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString());
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString());
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.controllerSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.unknownUser = "unknownUser";
    }
}

