/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u0014(\u00011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\n\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u001aC\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011%9\u0006A!A!\u0002\u0013A6\fC\u0003]\u0001\u0011\u0005Q\fC\u0004g\u0001\t\u0007I\u0011B4\t\r1\u0004\u0001\u0015!\u0003i\u0011\u001di\u0007A1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%IA\u001c\u0005\u0007s\u0002\u0001\u000b\u0011B8\t\u000fi\u0004\u0001\u0019!C\u0005w\"I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\b\u0003G\u0001\u0001\u0015)\u0003}\u0011\u001d\t)\u0003\u0001C)\u0003OAq!a\f\u0001\t#\n\t\u0004C\u0004\u0002<\u0001!\t&!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0015\u0002D!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003?\u0003A\u0011IAQ\u0011\u001d\t)\f\u0001C)\u0003oCq!a0\u0001\t#\n\t\rC\u0004\u0002H\u0002!\t%!3\t\u0013\u0005}\bA1A\u0005R\t\u0005\u0001\u0002\u0003B\u0005\u0001\u0001\u0006IAa\u0001\t\u0013\t-\u0001A1A\u0005R\t\u0005\u0001\u0002\u0003B\u0007\u0001\u0001\u0006IAa\u0001\t\u000f\t=\u0001\u0001\"\u0011\u0003\u0012!9!q\u0004\u0001\u0005R\t\u0005\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013BqA!\u001d\u0001\t\u0003\u0011\u0019HA\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$'B\u0001\u0015*\u0003\u0019\u0019XM\u001d<fe*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00180\u001b\u00059\u0013B\u0001\u0019(\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u00111\u0007\u0010\b\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR!aN\u0016\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mB\u0014\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA!E\u001b\u0005\u0011%BA\"*\u0003\u001d\u0019G.^:uKJL!!\u0012\"\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qhL\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003]%K!AS\u0014\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"AL'\n\u00059;#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003]EK!AU\u0014\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011a&V\u0005\u0003-\u001e\u0012qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u0002!\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\bC\u0001\u0018Z\u0013\tQvE\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug&\u0011qkL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011y{\u0006-\u00192dI\u0016\u0004\"A\f\u0001\t\u000bEB\u0001\u0019\u0001\u001a\t\u000b}B\u0001\u0019\u0001!\t\u000b\u001dC\u0001\u0019\u0001%\t\u000b-C\u0001\u0019\u0001'\t\u000b=C\u0001\u0019\u0001)\t\u000bMC\u0001\u0019\u0001+\t\u000b]C\u0001\u0019\u0001-\u0002\u0013I,\u0007\u000f\\5dC&#W#\u00015\u0011\u0005%TW\"\u0001\u001d\n\u0005-D$aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00115\f\u0007PQ=uKN,\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fA\u0001\\1oO*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u0005\u001dIe\u000e^3hKJ\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005\u0019\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]V\tA\u0010E\u0002j{~L!A \u001d\u0003\r=\u0003H/[8o!\u0011\t\t!!\u0005\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\taaY8n[>t'b\u0001\u0016\u0002\n)!\u00111BA\u0007\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qB\u0001\u0004_J<\u0017\u0002BA\n\u0003\u0007\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR!\u0011\u0011DA\u0010!\rI\u00171D\u0005\u0004\u0003;A$\u0001B+oSRD\u0001\"!\t\u0011\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\n\u0014\u0001F5o!J|wM]3tgB\u000b'\u000f^5uS>t\u0007%A\u0006mCR,7\u000f^#q_\u000eDG\u0003BA\u0015\u0003W\u00012![?i\u0011\u0019\tiC\u0005a\u0001\u007f\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0005\u0003g\tI\u0004E\u0002j\u0003kI1!a\u000e9\u0005\u0011auN\\4\t\r\u000552\u00031\u0001\u0000\u00031awnZ#oI>3gm]3u)\u0011\t\u0019$a\u0010\t\r\u00055B\u00031\u0001\u0000\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u000b\ni%a\u0014\u0011\t%l\u0018q\t\t\u0004]\u0005%\u0013bAA&O\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007BBA\u0017+\u0001\u0007q\u0010\u0003\u0004\u0002RU\u0001\r\u0001[\u0001\u0006KB|7\r[\u0001\u0010M\u0016$8\r\u001b$s_6dU-\u00193feR!\u0011qKA6!\u001d\tI&a\u0018\u0000\u0003Gj!!a\u0017\u000b\u0007\u0005u\u0003(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002\\\t\u0019Q*\u00199\u0011\t\u0005\u0015\u0014qM\u0007\u0002\u0001%\u0019\u0011\u0011N\u0018\u0003\u0013\u0019+Go\u00195ECR\f\u0007bBA7-\u0001\u0007\u0011qN\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0003c\niH\u0004\u0003\u0002t\u0005eTBAA;\u0015\u0011\t9(a\u0001\u0002\u0011I,\u0017/^3tiNLA!a\u001f\u0002v\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011qPAA\u0005\u001d\u0011U/\u001b7eKJTA!a\u001f\u0002v\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"a\"\u0002\u0016\u0006]\u00151\u0014\t\u0005Sv\fI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty)K\u0001\u0004Y><\u0017\u0002BAJ\u0003\u001b\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007BBA\u0017/\u0001\u0007q\u0010C\u0004\u0002\u001a^\u0001\r!a\r\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0003;;\u0002\u0019AA2\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uC\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$B!a)\u0002*B)\u0011\u0011LAS\u007f&!\u0011qUA.\u0005\r\u0019V\r\u001e\u0005\b\u0003WC\u0002\u0019AAW\u0003IIg.\u001b;jC24U\r^2i'R\fG/Z:\u0011\u000f\u0005e\u0013qL@\u00020B\u0019a&!-\n\u0007\u0005MvEA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\fQDZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003g\tI,a/\t\r\u00055\u0012\u00041\u0001\u0000\u0011\u0019\ti,\u0007a\u0001Q\u0006YA.Z1eKJ,\u0005o\\2i\u0003m1W\r^2i\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u00111GAb\u0003\u000bDa!!\f\u001b\u0001\u0004y\bBBA_5\u0001\u0007\u0001.\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003\u0017\f\u0019\u0010E\u0004\u0002Z\u0005}s0!4\u0011\t\u0005=\u0017Q\u001e\b\u0005\u0003#\f9O\u0004\u0003\u0002T\u0006\rh\u0002BAk\u0003CtA!a6\u0002`:!\u0011\u0011\\Ao\u001d\r)\u00141\\\u0005\u0003\u0003\u001fIA!a\u0003\u0002\u000e%\u0019!&!\u0003\n\t\u0005\u0015\u0011qA\u0005\u0005\u0003K\f\u0019!A\u0004nKN\u001c\u0018mZ3\n\t\u0005%\u00181^\u0001!\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002f\u0006\r\u0011\u0002BAx\u0003c\u0014a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0002j\u0006-\bbBA{7\u0001\u0007\u0011q_\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcBA-\u0003?z\u0018\u0011 \t\u0005\u0003K\nY0C\u0002\u0002~>\u0012\u0011\"\u00129pG\"$\u0015\r^1\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0003\u0004A\u0019\u0011N!\u0002\n\u0007\t\u001d\u0001HA\u0004C_>dW-\u00198\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e\u0003uI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005e!1\u0003B\u000b\u0011\u0019\ti\u0003\ta\u0001\u007f\"9!q\u0003\u0011A\u0002\te\u0011a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u00079\u0012Y\"C\u0002\u0003\u001e\u001d\u0012Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011\u0011\u0004B\u0012\u0005KAa!!\f\"\u0001\u0004y\bb\u0002B\u0014C\u0001\u0007\u00111G\u0001\u0007_\u001a47/\u001a;\u0002%9,\u0007\u0010\u001e*fC\u0012L\b+\u0019:uSRLwN\u001c\u000b\u0005\u0005[\u0011Y\u0004\u0005\u0003j{\n=\u0002CB5\u00032}\u0014)$C\u0002\u00034a\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001\u0018\u00038%\u0019!\u0011H\u0014\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\tu\"\u00051\u0001\u0003@\u0005a\u0001/\u0019:uSRLwN\\'baB9\u0011\u0011LA0\u007f\nU\u0012AF:fY\u0016\u001cG\u000fU1si&$\u0018n\u001c8U_\u001a+Go\u00195\u0015\t\t5\"Q\t\u0005\b\u0005{\u0019\u0003\u0019\u0001B \u0003Y\u0011W/\u001b7e\r\u0016$8\r\u001b$peB\u000b'\u000f^5uS>tGC\u0002B&\u0005S\u0012i\u0007\u0005\u0004\u0003N\tm#\u0011\r\b\u0005\u0005\u001f\u00129F\u0004\u0003\u0003R\tUcbA\u001b\u0003T%\t!&\u0003\u0002)S%\u0019!\u0011L\u0014\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!!Q\fB0\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019!\u0011L\u0014\u0011\t%l(1\r\t\u0005\u0005\u001b\u0012)'\u0003\u0003\u0003h\t}#\u0001\u0004*fa2L7-\u0019$fi\u000eD\u0007B\u0002B6I\u0001\u0007q0\u0001\u0002ua\"9!q\u000e\u0013A\u0002\tU\u0012A\u00034fi\u000eD7\u000b^1uK\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\t-#Q\u000f\u0005\b\u0005{)\u0003\u0019\u0001B \u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean isTruncationOnFetchSupported;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)CollectionConverters$.MODULE$.MapHasAsScala(request.fetchData()).asScala().toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel(), (Option<ClientMetadata>)None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(Predef$.MODULE$.wrapRefArray(request.fetchData().keySet().toArray()).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        Log futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LeaderOffsetIncremented$.MODULE$);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaMgr.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        });
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((IterableOnceOps)partitionMap.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$3 -> ReplicaAlterLogDirsThread.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
            requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)tp);
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaId;
            boolean bl = false;
            boolean bl2 = false;
            int n = this.replicaId();
            short forReplica_allowedVersion = ApiKeys.FETCH.latestVersion();
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(forReplica_allowedVersion, forReplica_allowedVersion, (int)forReplica_replicaId, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)((Set)Set$.MODULE$.empty()));
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)((Set)Set$.MODULE$.empty()));
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)x$1).asJava()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(data.error().code()).setHighWatermark(data.highWatermark()).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset()).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records()));
            return tuple2;
        });
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitionMap$1.get((Object)tp).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(52).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").toString()).append(new StringBuilder(81).append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, brokerTopicStats);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isOffsetForLeaderEpochSupported = true;
        this.isTruncationOnFetchSupported = false;
    }
}

