/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005\u0002\u0015BQA\u000e\u0001\u0005\u0002]BQ!\u0012\u0001\u0005\n\u0019CQ\u0001\u0015\u0001\u0005\u0002\u0015BQA\u0015\u0001\u0005\u0002\u0015Bq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004h\u0001\u0001\u0006IA\u0016\u0005\u0006Q\u0002!\t!\n\u0005\u0006U\u0002!\t!\n\u0005\u0006Y\u0002!\t!\n\u0005\u0006]\u0002!\t!\n\u0005\u0006a\u0002!\t!\n\u0005\u0006e\u0002!\t!\n\u0005\u0006i\u0002!\t!\n\u0005\u0006m\u0002!\t!\n\u0005\u0006q\u0002!\t!\n\u0005\u0006u\u0002!Ia\u001f\u0002\u0011\r\u0016$8\r[*fgNLwN\u001c+fgRT!!\u0006\f\u0002\rM,'O^3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0015\u0003A!Xm\u001d;OK^\u001cVm]:j_:LE\rF\u0001'!\tYr%\u0003\u0002)9\t!QK\\5uQ\t\u0011!\u0006\u0005\u0002,i5\tAF\u0003\u0002.]\u0005\u0019\u0011\r]5\u000b\u0005=\u0002\u0014a\u00026va&$XM\u001d\u0006\u0003cI\nQA[;oSRT\u0011aM\u0001\u0004_J<\u0017BA\u001b-\u0005\u0011!Vm\u001d;\u0002'\u0005\u001c8/\u001a:u\u0007\u0006\u001c\u0007.Z\"p]R\f\u0017N\\:\u0015\u0007\u0019BT\bC\u0003:\u0007\u0001\u0007!(A\u0003dC\u000eDW\r\u0005\u0002$w%\u0011A\b\u0006\u0002\u0012\r\u0016$8\r[*fgNLwN\\\"bG\",\u0007\"\u0002 \u0004\u0001\u0004y\u0014AC:fgNLwN\\%egB\u00191\u0004\u0011\"\n\u0005\u0005c\"A\u0003\u001fsKB,\u0017\r^3e}A\u00111dQ\u0005\u0003\tr\u00111!\u00138u\u0003-!W/\\7z\u0007J,\u0017\r^3\u0015\u0005\u001ds\u0005C\u0001%L\u001d\t\u0019\u0013*\u0003\u0002K)\u0005aa)\u001a;dQN+7o]5p]&\u0011A*\u0014\u0002\n\u0007\u0006\u001b\u0005*R0N\u0003BS!A\u0013\u000b\t\u000b=#\u0001\u0019\u0001\"\u0002\tML'0Z\u0001\u0011i\u0016\u001cHoU3tg&|gnQ1dQ\u0016D#!\u0002\u0016\u00021Q,7\u000f\u001e*fg&TXmQ1dQ\u0016$7+Z:tS>t7\u000f\u000b\u0002\u0007U\u0005yQ)\u0014)U3~\u0003\u0016I\u0015+`\u0019&\u001bF+F\u0001W!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\u0005kRLGNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&\u0001\u0002'jgR\u0004\"aX3\u000e\u0003\u0001T!!\u00192\u0002\r\r|W.\\8o\u0015\t92M\u0003\u0002ee\u00051\u0011\r]1dQ\u0016L!A\u001a1\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001R)\u0014)U3~\u0003\u0016I\u0015+`\u0019&\u001bF\u000bI\u0001\u0016i\u0016\u001cHoQ1dQ\u0016$G*Z1eKJ,\u0005o\\2iQ\tI!&\u0001\u000buKN$H*Y:u\r\u0016$8\r[3e\u000bB|7\r\u001b\u0015\u0003\u0015)\n\u0011\u0003^3ti\u001a+Go\u00195SKF,Xm\u001d;tQ\tY!&A\u000euKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r[*fgNLwN\u001c\u0015\u0003\u0019)\n!\u0004^3ti\u001a+Go\u00195TKN\u001c\u0018n\u001c8FqBL'/\u0019;j_:D#!\u0004\u0016\u0002;Q,7\u000f\u001e)sSZLG.Z4fIN+7o]5p]\"\u000bg\u000e\u001a7j]\u001eD#A\u0004\u0016\u00021Q,7\u000f\u001e.fe>\u001c\u0016N_3GKR\u001c\u0007nU3tg&|g\u000e\u000b\u0002\u0010U\u0005\u0011B/Z:u\t&4XM]4j]\u001e,\u0005o\\2iQ\t\u0001\"&\u0001\u0016uKN$H)\u001a9sS>\u0014\u0018\u000e^5{KN\u0004\u0016M\u001d;ji&|gn],ji\"\u0014VmY8sIN|e\u000e\\=)\u0005EQ\u0013!F1tg\u0016\u0014H\u000fU1si&$\u0018n\u001c8t\u001fJ$WM\u001d\u000b\u0005Mq\f\u0019\u0001C\u0003~%\u0001\u0007a0A\u0004d_:$X\r\u001f;\u0011\u0005\rz\u0018bAA\u0001)\taa)\u001a;dQ\u000e{g\u000e^3yi\"9\u0011Q\u0001\nA\u0002\u0005\u001d\u0011A\u00039beRLG/[8ogB)\u0011\u0011BA\r=:!\u00111BA\u000b\u001d\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t1\u00051AH]8pizJ\u0011!H\u0005\u0004\u0003/a\u0012a\u00029bG.\fw-Z\u0005\u0005\u00037\tiBA\u0002TKFT1!a\u0006\u001dQ\u001d\u0001\u0011\u0011EA\u0014\u0003S\u00012aKA\u0012\u0013\r\t)\u0003\f\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\b")
public class FetchSessionTest {
    private final List<TopicPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> Assertions.assertTrue((cache.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cache.get(sessionId).isDefined(), (String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<CachedPartition> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", i)));
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, (Function0 & Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, (Function0 & Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(30L, false, 40, (Function0 & Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 5, (Function0 & Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, (Function0 & Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, (Function0 & Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(410L, false, 5, (Function0 & Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0 & Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0 & Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, (Function0 & Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    private List<TopicPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 1);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request1.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        request1.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1))));
        request1.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, request1, this.EMPTY_PART_LIST(), false);
        Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)tp2));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        response.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(tp0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap request2 = new LinkedHashMap();
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(sessionId, 1), request2, this.EMPTY_PART_LIST(), false);
        Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)tp2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6))));
        request3.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        request3.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(new FetchMetadata(sessionId, 2), request3, this.EMPTY_PART_LIST(), false));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)tp0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)tp2));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 1);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request1.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty(), Optional.empty()));
        request1.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()));
        request1.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, request1, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        response.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(tp0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap request2 = new LinkedHashMap();
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(sessionId, 1), request2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        request3.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty(), Optional.empty()));
        request3.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(sessionId, 2), request3, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        FetchContext context = fetchManager.newContext(FetchMetadata.LEGACY, new HashMap(), this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData2.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context2 = fetchManager.newContext(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2 & Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 0)).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData2.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals(respData2, (Object)resp2.responseData());
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchContext context4 = fetchManager.newContext(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData5 = new LinkedHashMap();
        FetchContext context5 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2 & Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$2(reqData5Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(new TopicPartition("foo", 1)).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData().size());
        FetchContext context6 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData7 = new LinkedHashMap();
        FetchResponse resp7 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
            reqData8.put(new TopicPartition("bar", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            FetchContext context8 = fetchManager.newContext(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cache.size());
            LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
            respData8.put(new TopicPartition("bar", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            respData8.put(new TopicPartition("bar", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @Test
    public void testIncrementalFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData().size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(15L, 0L, 0, Optional.empty()));
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 1), new TopicPartition("bar", 0)}))).iterator();
        context2.foreachPartition((Function2 & Serializable)(topicPart, x$2) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$1(reqData2Iter, topicPart, x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("foo", 0)));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("bar", 0)).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("bar", 2)));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData2.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(new TopicPartition("bar", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData().size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session1req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session1context1 = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session2req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session2context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchContext context1v2 = fetchManager.newContext(new FetchMetadata(session1resp.sessionId(), 1), new LinkedHashMap(), new ArrayList(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session3req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session3context = fetchManager.newContext(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session1req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session1context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData().size());
        Assertions.assertEquals((int)1, (int)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session2req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session2context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session3req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session3context = fetchManager.newContext(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session4req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session4req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session4req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session4context = fetchManager.newContext(FetchMetadata.INITIAL, session4req, this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData4.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData4.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData().size());
        Assertions.assertFalse((boolean)cache.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData().size());
        LinkedHashMap reqData2 = new LinkedHashMap();
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        removed2.add(new TopicPartition("foo", 1));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData().isEmpty());
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 2);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData.put(tp1, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L));
        FetchResponseData.EpochEndOffset divergingEpoch = new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L);
        respData.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp1.responseData().keySet());
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(tp2), resp2.responseData().keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp3.responseData().keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(110L).setLastStableOffset(110L).setLogStartOffset(0L));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp4.responseData().keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeprioritizesPartitionsWithRecordsOnly() {
        void withRecords_records;
        void withRecords_timestampType;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 2);
        TopicPartition tp3 = new TopicPartition("zar", 3);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData.put(tp1, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp3, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2, tp3}), resp1.responseData().keySet());
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicPartition>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2, tp3}))));
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.emptySet(), resp2.responseData().keySet());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData3.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(100L, null)};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var16_16 = null;
        simpleRecordArray = null;
        respData3.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)));
        respData3.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp3.responseData().keySet());
        this.assertPartitionsOrder(context2, (Seq<TopicPartition>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp3, tp2}))));
    }

    private void assertPartitionsOrder(FetchContext context, Seq<TopicPartition> partitions) {
        ArrayBuffer partitionsInContext = ArrayBuffer$.MODULE$.empty();
        context.foreachPartition((Function2 & Serializable)(tp, x$3) -> {
            partitionsInContext.$plus$eq((Object)tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(partitions, (Object)partitionsInContext.toSeq());
    }

    private static final Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    private static final Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    private static final Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$1(java.util.Iterator reqData2Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData2Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicPart);
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$2(java.util.Iterator reqData5Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData5Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicPart);
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$1(Iterator reqData2Iter$2, TopicPartition topicPart, FetchRequest.PartitionData x$2) {
        Assertions.assertEquals((Object)reqData2Iter$2.next(), (Object)topicPart);
    }
}

