/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEd!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{!A!\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00038\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006_\u0002!\t\u0006\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B>\t\u0011\u00055\u0001\u00011A\u0005\niD\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u000f\u0005U\u0001\u0001)Q\u0005w\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u001c!A\u0011\u0011\u0006\u0001\u0005\u0002\r\nY\u0003\u0003\u0005\u0002J\u0001!\taIA&\u0011!\t\u0019\u0006\u0001C\u0001G\u0005U\u0003\u0002CAF\u0001\u0011\u00051%!$\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/A\u0001B!\u0007\u0001\t\u0003\u0019#1\u0004\u0005\b\u0005{\u0001A\u0011\u0002B \u0011!\u0011I\u0005\u0001C\u0001G\t-\u0003b\u0002B.\u0001\u0011%!Q\f\u0002\b\u00072,\u0017M\\3s\u0015\t!S%A\u0002m_\u001eT\u0011AJ\u0001\u0006W\u000647.Y\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022K\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\tIGm\u0001\u0001\u0016\u0003]\u0002\"!\u000b\u001d\n\u0005eR#aA%oi\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u001f\u0011\u0005yzT\"A\u0012\n\u0005\u0001\u001b#!C(gMN,G/T1q\u0003)ygMZ:fi6\u000b\u0007\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\u0006\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011\u0011FR\u0005\u0003\u000f*\u0012a\u0001R8vE2,\u0017!\u0003;ie>$H\u000f\\3s!\ty#*\u0003\u0002La\tIA\u000b\u001b:piRdWM]\u0001\u0005i&lW\r\u0005\u0002O/6\tqJ\u0003\u00022!*\u0011\u0011KU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W(\u0003\tQKW.Z\u0001\nG\",7m\u001b#p]\u0016\u0004B!K.^C&\u0011AL\u000b\u0002\n\rVt7\r^5p]F\u0002\"AX0\u000e\u0003AK!\u0001\u0019)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011FY\u0005\u0003G*\u0012A!\u00168ji\u00061A(\u001b8jiz\"\u0012BZ4iS*\\G.\u001c8\u0011\u0005y\u0002\u0001\"\u0002\u001b\f\u0001\u00049\u0004\"B\u001e\f\u0001\u0004i\u0004\"\u0002\"\f\u0001\u00049\u0004\"B\"\f\u0001\u00049\u0004\"\u0002#\f\u0001\u0004)\u0005\"\u0002%\f\u0001\u0004I\u0005\"\u0002'\f\u0001\u0004i\u0005\"B-\f\u0001\u0004Q\u0016A\u00037pO\u001e,'OT1nKV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\rM#(/\u001b8h\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011a0^\u0001\u0004]&|\u0017bAA\u0001{\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001dI,\u0017\r\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0002\t\u0011\u0005%a\"!AA\u0002m\f1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0005\t\u0011\u0005%\u0011#!AA\u0002m\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002\n1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011!\u00061!/Z2pe\u0012LA!!\n\u0002 \tq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001\b3fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u0006G2,\u0017M\u001c\u000b\u0005\u0003[\ty\u0004E\u0004*\u0003_\t\u0019$!\u000f\n\u0007\u0005E\"F\u0001\u0004UkBdWM\r\t\u0004S\u0005U\u0012bAA\u001cU\t!Aj\u001c8h!\rq\u00141H\u0005\u0004\u0003{\u0019#\u0001D\"mK\u0006tWM]*uCR\u001c\bbBA!+\u0001\u0007\u00111I\u0001\nG2,\u0017M\\1cY\u0016\u00042APA#\u0013\r\t9e\t\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u00023p\u00072,\u0017M\u001c\u000b\u0007\u0003[\ti%a\u0014\t\u000f\u0005\u0005c\u00031\u0001\u0002D!9\u0011\u0011\u000b\fA\u0002\u0005M\u0012a\u00043fY\u0016$X\rS8sSj|g.T:\u0002\u001b\rdW-\u00198TK\u001elWM\u001c;t)-\t\u0017qKA0\u0003\u0003\u000b))a\"\t\r\u0011:\u0002\u0019AA-!\rq\u00141L\u0005\u0004\u0003;\u001a#a\u0001'pO\"9\u0011\u0011M\fA\u0002\u0005\r\u0014\u0001C:fO6,g\u000e^:\u0011\r\u0005\u0015\u0014QOA>\u001d\u0011\t9'!\u001d\u000f\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c6\u0003\u0019a$o\\8u}%\t1&C\u0002\u0002t)\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002x\u0005e$aA*fc*\u0019\u00111\u000f\u0016\u0011\u0007y\ni(C\u0002\u0002\u0000\r\u0012!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019\t\u0019i\u0006a\u0001{\u0005\u0019Q.\u00199\t\u000f\u0005Es\u00031\u0001\u00024!9\u0011\u0011R\fA\u0002\u0005e\u0012!B:uCR\u001c\u0018!C2mK\u0006t\u0017J\u001c;p)M\t\u0017qRAJ\u0003;\u000b\t+a)\u0002.\u0006E\u00161XAh\u0011\u0019\t\t\n\u0007a\u0001;\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAK1\u0001\u0007\u0011qS\u0001\u000eg>,(oY3SK\u000e|'\u000fZ:\u0011\t\u0005u\u0011\u0011T\u0005\u0005\u00037\u000byBA\u0006GS2,'+Z2pe\u0012\u001c\bbBAP1\u0001\u0007\u00111P\u0001\u0005I\u0016\u001cH\u000f\u0003\u0004\u0002\u0004b\u0001\r!\u0010\u0005\b\u0003KC\u0002\u0019AAT\u00035\u0011X\r^1j]\u0012+G.\u001a;fgB\u0019\u0011&!+\n\u0007\u0005-&FA\u0004C_>dW-\u00198\t\r\u0005=\u0006\u00041\u00018\u0003Ei\u0017\r\u001f'pO6+7o]1hKNK'0\u001a\u0005\b\u0003gC\u0002\u0019AA[\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\rq\u0014qW\u0005\u0004\u0003s\u001b#AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007bBA_1\u0001\u0007\u0011qX\u0001\u0010C\u000e$\u0018N^3Qe>$WoY3sgB9\u0011\u0011YAe\u0003g9d\u0002BAb\u0003\u000b\u00042!!\u001b+\u0013\r\t9MK\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0017Q\u001a\u0002\u0004\u001b\u0006\u0004(bAAdU!9\u0011\u0011\u0012\rA\u0002\u0005e\u0012!E4s_^\u0014UO\u001a4feN|%OR1jYRI\u0011-!6\u0002X\u0006m\u0017Q\u001c\u0005\b\u0003+K\u0002\u0019AAL\u0011\u0019\tI.\u0007a\u0001o\u0005A\u0001o\\:ji&|g\u000e\u0003\u0004\u00020f\u0001\ra\u000e\u0005\b\u0003?L\u0002\u0019AAq\u00035iW-\\8ssJ+7m\u001c:egB!\u0011QDAr\u0013\u0011\t)/a\b\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003I\u0019\bn\\;mI\u0012K7oY1sI\n\u000bGo\u00195\u0015\u0011\u0005\u001d\u00161^A{\u0003oDq!!<\u001b\u0001\u0004\ty/A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002\u001e\u0005E\u0018\u0002BAz\u0003?\u00111BU3d_J$')\u0019;dQ\"9\u00111\u0017\u000eA\u0002\u0005U\u0006bBA}5\u0001\u0007\u0011qU\u0001\u0011e\u0016$\u0018-\u001b8Uq:l\u0015M]6feN\f!c\u001d5pk2$'+\u001a;bS:\u0014VmY8sIRa\u0011qUA\u0000\u0005\u0003\u0011\u0019A!\u0002\u0003\u000e!1\u00111Q\u000eA\u0002uBq!!*\u001c\u0001\u0004\t9\u000bC\u0004\u0002nn\u0001\r!a<\t\u000f\u0005\u00052\u00041\u0001\u0003\bA!\u0011Q\u0004B\u0005\u0013\u0011\u0011Y!a\b\u0003\rI+7m\u001c:e\u0011\u001d\tIi\u0007a\u0001\u0003s\t1b\u001a:po\n+hMZ3sgR\u0019\u0011Ma\u0005\t\r\u0005=F\u00041\u00018\u00039\u0011Xm\u001d;pe\u0016\u0014UO\u001a4feN$\u0012!Y\u0001\u0014OJ|W\u000f]*fO6,g\u000e^:CsNK'0\u001a\u000b\u000b\u0005;\u0011\u0019C!\r\u00036\te\u0002CBA3\u0005?\t\u0019'\u0003\u0003\u0003\"\u0005e$\u0001\u0002'jgRDq!!\u0019\u001f\u0001\u0004\u0011)\u0003\u0005\u0004\u0003(\t5\u00121P\u0007\u0003\u0005SQ1Aa\u000b+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005_\u0011IC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u0019\u0011\u0019D\ba\u0001o\u00059Q.\u0019=TSj,\u0007B\u0002B\u001c=\u0001\u0007q'\u0001\u0007nCbLe\u000eZ3y'&TX\rC\u0004\u0003<y\u0001\r!a\r\u0002-\u0019L'o\u001d;V]\u000edW-\u00198bE2,wJ\u001a4tKR\f\u0011\u0004\\1ti>3gm]3u\r>\u0014h)\u001b:tiN+w-\\3oiR1\u00111\u0007B!\u0005\u000fBqAa\u0011 \u0001\u0004\u0011)%\u0001\u0003tK\u001e\u001c\bCBA3\u0005?\tY\bC\u0004\u0003<}\u0001\r!a\r\u0002\u001d\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'baRY\u0011M!\u0014\u0003P\tM#q\u000bB-\u0011\u0019!\u0003\u00051\u0001\u0002Z!9!\u0011\u000b\u0011A\u0002\u0005M\u0012!B:uCJ$\bb\u0002B+A\u0001\u0007\u00111G\u0001\u0004K:$\u0007BBABA\u0001\u0007Q\bC\u0004\u0002\n\u0002\u0002\r!!\u000f\u00021\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\u001a{'oU3h[\u0016tG\u000f\u0006\t\u0002(\n}#\u0011\rB3\u0005O\u0012YG!\u001c\u0003p!1\u0011\u0011S\u0011A\u0002uCqAa\u0019\"\u0001\u0004\tY(A\u0004tK\u001elWM\u001c;\t\r\u0005\r\u0015\u00051\u0001>\u0011\u001d\u0011I'\ta\u0001\u0003g\t1b\u001d;beR|eMZ:fi\"1\u0011qV\u0011A\u0002]Bq!a-\"\u0001\u0004\t)\fC\u0004\u0002\n\u0006\u0002\r!!\u000f")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        long l;
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogSegment seg = (LogSegment)some.value();
            l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        long deleteHorizonMs = l;
        return this.doClean(cleanable, deleteHorizonMs);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)})));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs, stats);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log, ((LogSegment)segments.head()).baseOffset());
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> map.latestOffset() + 1L));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, (Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
                boolean retainDeletes = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Cleaning segment ").append(startOffset).append(" in log ").append(log.name()).append(" (largest timestamp ").append(new Date(currentSegment.largestTimestamp())).append(") ").append(new StringBuilder(16).append("into ").append(cleaned.baseOffset()).append(", ").append((Object)(retainDeletes ? "retaining" : "discarding")).append(" deletes.").toString()).toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducersWithLastSequence(), stats);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments, log.replaceSegments$default$3());
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            finally {
                throw e;
            }
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, Object> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, transactionMetadata, retainDeletes, activeProducers, map, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final boolean retainDeletes$2;
            private final Map activeProducers$1;
            private final OffsetMap map$2;
            private final CleanerStats stats$3;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).contains((Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$2, this.retainDeletes$2, batch, record, this.stats$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.retainDeletes$2 = retainDeletes$2;
                this.activeProducers$1 = activeProducers$1;
                this.map$2 = map$2;
                this.stats$3 = stats$3;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && record.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        block1: {
            if (this.readBuffer().capacity() > this.ioBufferSize) {
                this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            }
            if (this.writeBuffer().capacity() <= this.ioBufferSize) break block1;
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? ((LogSegment)segs.apply(1)).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$2(full, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$buildOffsetMap$3(this, log, full, map, start, transactionMetadata, stats, dirty, segment);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        boolean bl;
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            this.restoreBuffers();
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$2(BooleanRef full$1, LogSegment segment) {
        return !full$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$3(Cleaner $this, Log log$4, BooleanRef full$1, OffsetMap map$3, long start$1, CleanedTransactionMetadata transactionMetadata$2, CleanerStats stats$4, Buffer dirty$1, LogSegment segment) {
        block0: {
            $this.checkDone.apply((Object)log$4.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$3, start$1, Predef$.MODULE$.Integer2int(log$4.config().maxMessageSize()), transactionMetadata$2, stats$4);
            if (!full$1.elem) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$2, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$5, long startOffset$2, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        block4: {
            if (batch.isControlBatch()) {
                transactionMetadata$3.onControlBatchRead((RecordBatch)batch);
                stats$5.indexMessagesRead(1);
            } else {
                boolean isAborted = transactionMetadata$3.onBatchRead((RecordBatch)batch);
                if (isAborted) {
                    stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                } else {
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                        Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$2, map$4, maxDesiredMapSize$1, nonLocalReturnKey1$1, stats$5, record);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (batch.lastOffset() < startOffset$2) break block4;
            map$4.updateLatestOffset(batch.lastOffset());
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

