/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.junit.Assert;
import org.junit.Test;

public class LeaveGroupRequestTest {
    @Test
    public void testLeaveConstructor() {
        String groupId = "group_id";
        String memberId = "member_id";
        int throttleTimeMs = 10;
        LeaveGroupRequestData expectedData = new LeaveGroupRequestData().setGroupId("group_id").setMemberId("member_id");
        LeaveGroupRequest.Builder builder = new LeaveGroupRequest.Builder(new LeaveGroupRequestData().setGroupId("group_id").setMemberId("member_id"));
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            LeaveGroupRequest request = builder.build(version);
            Assert.assertEquals((Object)expectedData, (Object)request.data());
            int expectedThrottleTime = version >= 1 ? 10 : 0;
            LeaveGroupResponse expectedResponse = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setThrottleTimeMs(expectedThrottleTime));
            Assert.assertEquals((Object)expectedResponse, (Object)request.getErrorResponse(10, (Throwable)Errors.NOT_CONTROLLER.exception()));
        }
    }
}

