/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class RenewDelegationTokenResponseData
implements ApiMessage {
    private short errorCode;
    private long expiryTimestampMs;
    private int throttleTimeMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public RenewDelegationTokenResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public RenewDelegationTokenResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public RenewDelegationTokenResponseData() {
        this.errorCode = 0;
        this.expiryTimestampMs = 0L;
        this.throttleTimeMs = 0;
    }

    public short apiKey() {
        return 39;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        this.expiryTimestampMs = readable.readLong();
        this.throttleTimeMs = readable.readInt();
    }

    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeLong(this.expiryTimestampMs);
        writable.writeInt(this.throttleTimeMs);
    }

    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        this.expiryTimestampMs = struct.getLong("expiry_timestamp_ms");
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("expiry_timestamp_ms", (Object)this.expiryTimestampMs);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 2;
        size += 8;
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RenewDelegationTokenResponseData)) {
            return false;
        }
        RenewDelegationTokenResponseData other = (RenewDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.expiryTimestampMs != other.expiryTimestampMs) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + ((int)(this.expiryTimestampMs >> 32) ^ (int)this.expiryTimestampMs);
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public String toString() {
        return "RenewDelegationTokenResponseData(errorCode=" + this.errorCode + ", expiryTimestampMs=" + this.expiryTimestampMs + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public long expiryTimestampMs() {
        return this.expiryTimestampMs;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public RenewDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public RenewDelegationTokenResponseData setExpiryTimestampMs(long v) {
        this.expiryTimestampMs = v;
        return this;
    }

    public RenewDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("expiry_timestamp_ms", (Type)Type.INT64, "The timestamp in milliseconds at which this token expires."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

