/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class BSFJavaScriptEngine
extends BSFEngineImpl {
    private Scriptable global;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object object, String method, Object[] args) throws BSFException {
        Object retval = null;
        try {
            Context cx = Context.enter();
            Object fun = this.global.get(method, this.global);
            if (fun == Scriptable.NOT_FOUND) {
                throw new EvaluatorException("function " + method + " not found.", "none", 0);
            }
            cx.setOptimizationLevel(-1);
            cx.setGeneratingDebug(false);
            cx.setGeneratingSource(false);
            cx.setOptimizationLevel(0);
            cx.setDebugger(null, null);
            retval = ((Function)fun).call(cx, this.global, this.global, args);
            if (retval instanceof Wrapper) {
                retval = ((Wrapper)retval).unwrap();
            }
        }
        catch (Throwable t) {
            BSFJavaScriptEngine.handleError(t);
        }
        finally {
            Context.exit();
        }
        return retval;
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        if (bean.bean instanceof Number || bean.bean == null || bean.bean instanceof String || bean.bean instanceof Boolean) {
            this.global.put(bean.name, this.global, bean.bean);
        } else {
            Scriptable wrapped = Context.toObject((Object)bean.bean, (Scriptable)this.global);
            this.global.put(bean.name, this.global, (Object)wrapped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        String scriptText = oscript.toString();
        Object retval = null;
        try {
            Context cx = Context.enter();
            cx.setOptimizationLevel(-1);
            cx.setGeneratingDebug(false);
            cx.setGeneratingSource(false);
            cx.setOptimizationLevel(0);
            cx.setDebugger(null, null);
            retval = cx.evaluateString(this.global, scriptText, source, lineNo, null);
            if (retval instanceof NativeJavaObject) {
                retval = ((NativeJavaObject)retval).unwrap();
            }
        }
        catch (Throwable t) {
            BSFJavaScriptEngine.handleError(t);
        }
        finally {
            Context.exit();
        }
        return retval;
    }

    private static void handleError(Throwable t) throws BSFException {
        Throwable target = t;
        if (t instanceof WrappedException) {
            target = ((WrappedException)t).getWrappedException();
        }
        String message = null;
        if (target instanceof JavaScriptException) {
            message = target.getLocalizedMessage();
            Object value = ((JavaScriptException)target).getValue();
            if (value instanceof Throwable) {
                target = (Throwable)value;
            }
        } else if (target instanceof EvaluatorException || target instanceof SecurityException) {
            message = target.getLocalizedMessage();
        } else if (target instanceof RuntimeException) {
            message = "Internal Error: " + target.toString();
        } else if (target instanceof StackOverflowError) {
            message = "Stack Overflow";
        }
        if (message == null) {
            message = target.toString();
        }
        if (target instanceof Error && !(target instanceof StackOverflowError)) {
            throw (Error)target;
        }
        throw new BSFException(500, "JavaScript Error: " + message, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        try {
            Context cx = Context.enter();
            this.global = new ImporterTopLevel(cx);
            Scriptable bsf = Context.toObject((Object)new BSFFunctions(mgr, (BSFEngine)this), (Scriptable)this.global);
            this.global.put("bsf", this.global, (Object)bsf);
            Vector beans = declaredBeans;
            for (BSFDeclaredBean declaredBean : beans) {
                this.declareBean(declaredBean);
            }
        }
        catch (Throwable t) {
            BSFJavaScriptEngine.handleError(t);
        }
        finally {
            Context.exit();
        }
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.global.delete(bean.name);
    }
}

