/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericControllerSchema;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericController
extends AbstractTestElement
implements Controller,
Serializable,
TestCompilerHelper {
    private static final long serialVersionUID = 235L;
    private static final Logger log = LoggerFactory.getLogger(GenericController.class);
    static final String INDEX_VAR_NAME_SUFFIX = "__idx";
    private transient Deque<LoopIterationListener> iterationListeners = new ArrayDeque<LoopIterationListener>();
    private transient IdentityHashMap<TestElement, Object> children = new IdentityHashMap();
    private static final Object DUMMY = new Object();
    protected transient List<TestElement> subControllersAndSamplers = new ArrayList<TestElement>();
    protected transient int current;
    private transient int iterCount;
    private transient boolean done;
    private transient boolean first;

    @Override
    public GenericControllerSchema getSchema() {
        return GenericControllerSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends GenericController, ? extends GenericControllerSchema> getProps() {
        return new PropertiesAccessor<GenericController, GenericControllerSchema>(this, this.getSchema());
    }

    @Override
    public void initialize() {
        this.resetCurrent();
        this.resetIterCount();
        this.done = false;
        this.first = true;
        this.initializeSubControllers();
    }

    protected void initializeSubControllers() {
        for (TestElement te : this.subControllersAndSamplers) {
            if (!(te instanceof GenericController)) continue;
            ((Controller)te).initialize();
        }
    }

    protected void reInitialize() {
        this.resetCurrent();
        this.incrementIterCount();
        this.setFirst(true);
        this.recoverRunningVersion();
    }

    @Override
    public Sampler next() {
        this.fireIterEvents();
        log.debug("Calling next on: {}", GenericController.class);
        if (this.isDone()) {
            return null;
        }
        Sampler returnValue = null;
        try {
            TestElement currentElement = this.getCurrentElement();
            this.setCurrentElement(currentElement);
            returnValue = currentElement == null ? this.nextIsNull() : (currentElement instanceof Sampler ? this.nextIsASampler((Sampler)currentElement) : this.nextIsAController((Controller)currentElement));
        }
        catch (NextIsNullException nextIsNullException) {
            // empty catch block
        }
        return returnValue;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean done) {
        this.done = done;
    }

    protected boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean b) {
        this.first = b;
    }

    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            sampler = this.next();
        }
        return sampler;
    }

    protected Sampler nextIsASampler(Sampler element) throws NextIsNullException {
        this.incrementCurrent();
        return element;
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        return null;
    }

    @Override
    public void triggerEndOfLoop() {
        this.reInitialize();
    }

    protected void currentReturnedNull(Controller c) {
        if (c.isDone()) {
            this.removeCurrentElement();
        } else {
            this.incrementCurrent();
        }
    }

    protected List<TestElement> getSubControllers() {
        return this.subControllersAndSamplers;
    }

    private void addElement(TestElement child) {
        this.subControllersAndSamplers.add(child);
    }

    protected void setCurrentElement(TestElement currentElement) throws NextIsNullException {
    }

    protected TestElement getCurrentElement() throws NextIsNullException {
        if (this.current < this.subControllersAndSamplers.size()) {
            return this.subControllersAndSamplers.get(this.current);
        }
        if (this.subControllersAndSamplers.isEmpty()) {
            this.setDone(true);
            throw new NextIsNullException();
        }
        return null;
    }

    protected void removeCurrentElement() {
        this.subControllersAndSamplers.remove(this.current);
    }

    protected void incrementCurrent() {
        ++this.current;
    }

    protected void resetCurrent() {
        this.current = 0;
    }

    @Override
    public void addTestElement(TestElement child) {
        if (child instanceof Controller || child instanceof Sampler) {
            this.addElement(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addTestElementOnce(TestElement child) {
        IdentityHashMap<TestElement, Object> identityHashMap = this.children;
        synchronized (identityHashMap) {
            if (this.children.putIfAbsent(child, DUMMY) == null) {
                this.addTestElement(child);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addIterationListener(LoopIterationListener lis) {
        this.iterationListeners.addFirst(lis);
    }

    @Override
    public void removeIterationListener(LoopIterationListener iterationListener) {
        Iterator<LoopIterationListener> iterator = this.iterationListeners.iterator();
        while (iterator.hasNext()) {
            LoopIterationListener listener = iterator.next();
            if (listener != iterationListener) continue;
            iterator.remove();
            break;
        }
    }

    protected void fireIterEvents() {
        if (this.isFirst()) {
            this.fireIterationStart();
            this.first = false;
        }
    }

    protected void fireIterationStart() {
        LoopIterationEvent event = new LoopIterationEvent(this, this.getIterCount());
        for (LoopIterationListener item : this.iterationListeners) {
            item.iterationStart(event);
        }
    }

    protected int getIterCount() {
        return this.iterCount;
    }

    protected void incrementIterCount() {
        ++this.iterCount;
    }

    protected void resetIterCount() {
        this.iterCount = 0;
    }

    protected Object readResolve() {
        this.iterationListeners = new ArrayDeque<LoopIterationListener>();
        this.children = new IdentityHashMap();
        this.subControllersAndSamplers = new ArrayList<TestElement>();
        return this;
    }
}

