/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.rmi.RMIServerSocketFactoryImpl;
import org.apache.jmeter.rmi.SSLRMIClientSocketFactory;
import org.apache.jmeter.rmi.SSLRMIServerSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RmiUtils {
    private static final Logger log = LoggerFactory.getLogger(RmiUtils.class);
    public static final int DEFAULT_RMI_REGISTRY_PORT = JMeterUtils.getPropDefault("server_port", 0);
    public static final int DEFAULT_RMI_PORT = JMeterUtils.getPropDefault("server.rmi.port", 1099);
    public static final int DEFAULT_LOCAL_PORT = JMeterUtils.getPropDefault("server.rmi.localport", 0);
    private static final String KEYSTORE_TYPE = JMeterUtils.getPropDefault("server.rmi.ssl.keystore.type", "JKS");
    private static final String KEYSTORE_FILE = JMeterUtils.getPropDefault("server.rmi.ssl.keystore.file", "rmi_keystore.jks");
    private static final String KEYSTORE_PASSWORD = JMeterUtils.getPropDefault("server.rmi.ssl.keystore.password", "changeit");
    private static final String KEYSTORE_ALIAS = JMeterUtils.getPropDefault("server.rmi.ssl.keystore.alias", "rmi");
    private static final String TRUSTSTORE_TYPE = JMeterUtils.getPropDefault("server.rmi.ssl.truststore.type", KEYSTORE_TYPE);
    private static final String TRUSTSTORE_FILE = JMeterUtils.getPropDefault("server.rmi.ssl.truststore.file", KEYSTORE_FILE);
    private static final String TRUSTSTORE_PASSWORD = JMeterUtils.getPropDefault("server.rmi.ssl.truststore.password", KEYSTORE_PASSWORD);
    private static final boolean SSL_DISABLED = JMeterUtils.getPropDefault("server.rmi.ssl.disable", false);

    private RmiUtils() {
    }

    public static RMIClientSocketFactory createClientSocketFactory() {
        if (SSL_DISABLED) {
            log.info("Disabling SSL for RMI as server.rmi.ssl.disable is set to 'true'");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)KEYSTORE_FILE)) {
            Validate.validState((boolean)SSL_DISABLED, (String)"No keystore for RMI over SSL specified. Set 'server.rmi.ssl.disable' to true, if this is intentional,if not run create-rmi-keystore.bat/create-rmi-keystore.sh to create a keystore and distribute it on client and serversused for distributed testing.", (Object[])new Object[0]);
            return null;
        }
        SSLRMIClientSocketFactory factory = new SSLRMIClientSocketFactory();
        factory.setAlias(KEYSTORE_ALIAS);
        factory.setKeystore(KEYSTORE_FILE, KEYSTORE_TYPE, KEYSTORE_PASSWORD);
        factory.setTruststore(TRUSTSTORE_FILE, TRUSTSTORE_TYPE, TRUSTSTORE_PASSWORD);
        return factory;
    }

    public static RMIServerSocketFactory createServerSocketFactory() throws RemoteException {
        if (SSL_DISABLED) {
            log.info("Disabling SSL for RMI as server.rmi.ssl.disable is set to 'true'");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)KEYSTORE_FILE)) {
            Validate.validState((boolean)SSL_DISABLED, (String)"No keystore for RMI over SSL specified. Set 'server.rmi.ssl.disable' to true, if this is intentional.", (Object[])new Object[0]);
            return new RMIServerSocketFactoryImpl(RmiUtils.getRmiHost());
        }
        SSLRMIServerSocketFactory factory = new SSLRMIServerSocketFactory(RmiUtils.getRmiHost());
        factory.setAlias(KEYSTORE_ALIAS);
        factory.setKeystore(KEYSTORE_FILE, KEYSTORE_TYPE, KEYSTORE_PASSWORD);
        factory.setTruststore(TRUSTSTORE_FILE, TRUSTSTORE_TYPE, TRUSTSTORE_PASSWORD);
        return factory;
    }

    public static InetAddress getRmiHost() throws RemoteException {
        InetAddress localHost = null;
        String host = System.getProperties().getProperty("java.rmi.server.hostname");
        try {
            if (host == null) {
                log.info("System property 'java.rmi.server.hostname' is not defined, using localHost address");
                localHost = InetAddress.getLocalHost();
            } else {
                log.info("Resolving by name the value of System property 'java.rmi.server.hostname': {}", (Object)host);
                localHost = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException e) {
            throw new RemoteException("Cannot start. Unable to get local host IP address.", e);
        }
        if (log.isInfoEnabled()) {
            log.info("Local IP address={}", (Object)localHost.getHostAddress());
        }
        if (host == null && localHost.isLoopbackAddress()) {
            String hostName = localHost.getHostName();
            throw new RemoteException("Cannot start. " + hostName + " is a loopback address.");
        }
        return localHost;
    }

    public static int getRmiRegistryPort() {
        return DEFAULT_RMI_REGISTRY_PORT == 0 ? DEFAULT_RMI_PORT : DEFAULT_RMI_REGISTRY_PORT;
    }

    static {
        if (DEFAULT_LOCAL_PORT != 0) {
            System.out.println("Using local port: " + DEFAULT_LOCAL_PORT);
        }
    }
}

