/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.rmi;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;

public class AliasKeyManager
implements X509KeyManager {
    private final String alias;
    private final X509KeyManager km;

    public AliasKeyManager(X509KeyManager km, String alias) {
        this.km = km;
        this.alias = alias;
    }

    public static AliasKeyManager[] wrap(KeyManager[] kms, String alias) {
        AliasKeyManager validManager = Arrays.asList(kms).stream().filter(m -> m instanceof X509KeyManager).map(m -> (X509KeyManager)m).filter(m -> m.getPrivateKey(alias) != null).map(m -> new AliasKeyManager((X509KeyManager)m, alias)).findFirst().orElseThrow(() -> new IllegalArgumentException("No key found for alias '" + alias + "'"));
        return new AliasKeyManager[]{validManager};
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.km.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.km.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.km.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.km.getServerAliases(keyType, issuers);
    }
}

