/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.report.core.CsvSampleReader;
import org.apache.jmeter.report.core.CsvSampleWriter;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleBuilder;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVersusRequestsGraphConsumer
extends AbstractGraphConsumer {
    private static final Long ONE = 1L;
    public static final String RESULT_CTX_GRANULARITY = "granularity";
    public static final String TIME_INTERVAL_LABEL = "Interval";
    private long granularity;
    private final TimeCountConsumer embeddedConsumer = new TimeCountConsumer(this);

    public long getGranularity() {
        return this.granularity;
    }

    public final void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    protected AbstractVersusRequestsGraphConsumer() {
        this.setGranularity(1L);
    }

    @Override
    public void startConsuming() {
        this.embeddedConsumer.startConsuming();
    }

    private void startConsumingBase() {
        super.startConsuming();
    }

    @Override
    public void setConsumedMetadata(SampleMetadata sampleMetadata, int channel) {
        this.embeddedConsumer.setConsumedMetadata(sampleMetadata, channel);
    }

    private void setConsumedMetadataBase(SampleMetadata sampleMetadata, int channel) {
        super.setConsumedMetadata(sampleMetadata, channel);
    }

    @Override
    public void consume(Sample sample, int channel) {
        this.embeddedConsumer.consume(sample, channel);
    }

    private void consumeBase(Sample sample, int channel) {
        super.consume(sample, channel);
    }

    @Override
    public void stopConsuming() {
        this.embeddedConsumer.stopConsuming();
    }

    public void stopConsumingBase() {
        super.stopConsuming();
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        parentResult.setResult(RESULT_CTX_GRANULARITY, new ValueResultData(this.granularity));
    }

    private static class TimeCountConsumer
    extends AbstractSampleConsumer {
        private static final Logger log = LoggerFactory.getLogger(TimeCountConsumer.class);
        private ArrayList<SampleBuilder> builders = new ArrayList();
        private ArrayList<FileInfo> fileInfos = new ArrayList();
        private HashMap<Long, Long> counts = new HashMap();
        boolean createdWorkDir = false;
        private final AbstractVersusRequestsGraphConsumer parent;

        public TimeCountConsumer(AbstractVersusRequestsGraphConsumer parent) {
            this.parent = parent;
        }

        private Long getTimeInterval(Sample sample) {
            long time = sample.getEndTime();
            return time - time % this.parent.getGranularity();
        }

        private void initProducedMetadata() {
            this.builders.clear();
            int channelCount = this.getConsumedChannelCount();
            for (int i = 0; i < channelCount; ++i) {
                SampleMetadata consumedMetadata = this.getConsumedMetadata(i);
                int colCount = consumedMetadata.getColumnCount();
                String[] names = new String[colCount + 1];
                for (int j = 0; j < colCount; ++j) {
                    names[j] = consumedMetadata.getColumnName(j);
                }
                names[colCount] = AbstractVersusRequestsGraphConsumer.TIME_INTERVAL_LABEL;
                SampleMetadata producedMetadata = new SampleMetadata(consumedMetadata.getSeparator(), names);
                this.builders.add(new SampleBuilder(producedMetadata));
                this.parent.setConsumedMetadataBase(producedMetadata, i);
            }
        }

        private Sample createIndexedSample(Sample sample, int channel, double count) {
            SampleBuilder builder = this.builders.get(channel);
            SampleMetadata metadata = builder.getMetadata();
            int colCount = metadata.getColumnCount();
            for (int i = 0; i < colCount - 1; ++i) {
                builder.add(sample.getData(i));
            }
            builder.add(String.valueOf(count));
            return builder.build();
        }

        @Override
        public void startConsuming() {
            File workDir = this.parent.getWorkingDirectory();
            this.createdWorkDir = false;
            if (!workDir.exists()) {
                this.createdWorkDir = workDir.mkdir();
                if (!this.createdWorkDir) {
                    String message = String.format("Cannot create working directory \"%s\"", workDir);
                    log.error(message);
                    throw new SampleException(message);
                }
            }
            int channelsCount = this.getConsumedChannelCount();
            for (int i = 0; i < channelsCount; ++i) {
                try {
                    File tmpFile = File.createTempFile(this.parent.getName(), "-" + i, workDir);
                    tmpFile.deleteOnExit();
                    this.fileInfos.add(new FileInfo(tmpFile, this.getConsumedMetadata(i)));
                    continue;
                }
                catch (IOException ex) {
                    String message = String.format("Cannot create temporary file for channel #%d", i);
                    log.error(message, (Throwable)ex);
                    throw new SampleException(message, ex);
                }
            }
            this.initProducedMetadata();
        }

        @Override
        public void consume(Sample sample, int channel) {
            Long time = this.getTimeInterval(sample);
            Long count = this.counts.get(time);
            if (count != null) {
                this.counts.put(time, count + 1L);
            } else {
                this.counts.put(time, ONE);
            }
            this.fileInfos.get(channel).getWriter().write(sample);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopConsuming() {
            this.parent.startConsumingBase();
            int channelsCount = this.getConsumedChannelCount();
            for (int i = 0; i < channelsCount; ++i) {
                FileInfo fileInfo = this.fileInfos.get(i);
                CsvSampleWriter writer = fileInfo.getWriter();
                writer.close();
                File file = fileInfo.getFile();
                try (CsvSampleReader reader = new CsvSampleReader(file, this.getConsumedMetadata(i));){
                    while (reader.hasNext()) {
                        Sample sample = reader.readSample();
                        Long requestsPerGranularity = this.counts.get(this.getTimeInterval(sample));
                        Long requestsPerSecond = requestsPerGranularity * 1000L / this.parent.getGranularity();
                        this.parent.consumeBase(this.createIndexedSample(sample, i, requestsPerSecond.longValue()), i);
                    }
                    continue;
                }
                finally {
                    if (!file.delete()) {
                        log.warn("Could not delete intermediate file {}", (Object)file.getAbsolutePath());
                    }
                }
            }
            if (this.createdWorkDir) {
                File workingDir = this.parent.getWorkingDirectory();
                try {
                    FileUtils.deleteDirectory((File)workingDir);
                }
                catch (IOException e) {
                    log.warn("Cannot delete created temporary directory, '{}'", (Object)workingDir, (Object)e);
                }
            }
            this.parent.stopConsumingBase();
        }

        private class FileInfo {
            private final File file;
            private final CsvSampleWriter writer;

            public FileInfo(File file, SampleMetadata metadata) {
                this.file = file;
                this.writer = new CsvSampleWriter(file, metadata);
            }

            public File getFile() {
                return this.file;
            }

            public CsvSampleWriter getWriter() {
                return this.writer;
            }
        }
    }
}

