/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class LoopController
extends GenericController
implements Serializable {
    static final String INDEX_VAR_NAME_SUFFIX = "__idx";
    public static final int INFINITE_LOOP_COUNT = -1;
    public static final String LOOPS = "LoopController.loops";
    private static final long serialVersionUID = 7833960784370272300L;
    private static final String CONTINUE_FOREVER = "LoopController.continue_forever";
    private transient int loopCount = 0;
    private transient Integer nbLoops;

    public LoopController() {
        this.setContinueForeverPrivate(true);
    }

    public void setLoops(int loops) {
        this.setProperty(new IntegerProperty(LOOPS, loops));
    }

    public void setLoops(String loopValue) {
        this.setProperty(new StringProperty(LOOPS, loopValue));
    }

    public int getLoops() {
        if (this.nbLoops == null || this.nbLoops == 0 || this.nbLoops == -1) {
            try {
                JMeterProperty prop = this.getProperty(LOOPS);
                this.nbLoops = Integer.valueOf(prop.getStringValue());
            }
            catch (NumberFormatException e) {
                this.nbLoops = 0;
            }
        }
        return this.nbLoops;
    }

    public String getLoopString() {
        return this.getPropertyAsString(LOOPS);
    }

    public void setContinueForever(boolean forever) {
        this.setContinueForeverPrivate(forever);
    }

    private void setContinueForeverPrivate(boolean forever) {
        this.setProperty(new BooleanProperty(CONTINUE_FOREVER, forever));
    }

    private boolean getContinueForever() {
        return this.getPropertyAsBoolean(CONTINUE_FOREVER);
    }

    @Override
    public Sampler next() {
        try {
            if (this.endOfLoop()) {
                if (!this.getContinueForever()) {
                    this.setDone(true);
                }
                Sampler sampler = null;
                return sampler;
            }
            Sampler sampler = super.next();
            return sampler;
        }
        finally {
            JMeterVariables variables = JMeterContextService.getContext().getVariables();
            if (variables != null) {
                variables.putObject(JMeterUtils.formatJMeterExportedVariableName(this.getName() + INDEX_VAR_NAME_SUFFIX), this.loopCount);
            }
        }
    }

    private boolean endOfLoop() {
        int loops = this.getLoops();
        return loops > -1 && this.loopCount >= loops;
    }

    @Override
    protected void setDone(boolean done) {
        this.nbLoops = null;
        super.setDone(done);
    }

    @Override
    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop()) {
            if (!this.getContinueForever()) {
                this.setDone(true);
            } else {
                this.resetLoopCount();
            }
            return null;
        }
        return this.next();
    }

    @Override
    public void triggerEndOfLoop() {
        super.triggerEndOfLoop();
        this.resetLoopCount();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        this.loopCount = 0;
        this.nbLoops = null;
    }

    @Override
    protected int getIterCount() {
        return this.loopCount + 1;
    }

    @Override
    protected void reInitialize() {
        this.setFirst(true);
        this.resetCurrent();
        this.incrementLoopCount();
        this.recoverRunningVersion();
    }

    public void startNextLoop() {
        this.reInitialize();
    }
}

