/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.jmeter.report.processor.Aggregator;
import org.apache.jmeter.util.JMeterUtils;

public class PercentileAggregator
implements Aggregator {
    private static final int SLIDING_WINDOW_SIZE = JMeterUtils.getPropDefault("jmeter.reportgenerator.statistic_window", 20000);
    private final DescriptiveStatistics statistics;
    private final double percentileIndex;

    public PercentileAggregator(double index) {
        this.statistics = new DescriptiveStatistics(SLIDING_WINDOW_SIZE);
        this.percentileIndex = index;
    }

    public PercentileAggregator(PercentileAggregator lastAggregator) {
        this.statistics = new DescriptiveStatistics(lastAggregator.statistics);
        this.percentileIndex = lastAggregator.percentileIndex;
    }

    @Override
    public long getCount() {
        return this.statistics.getN();
    }

    @Override
    public double getResult() {
        return this.statistics.getPercentile(this.percentileIndex);
    }

    @Override
    public void addValue(double value) {
        this.statistics.addValue(value);
    }

    @Override
    public void reset() {
        this.statistics.clear();
    }
}

