/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.TestFragmentController;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UndoHistory;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuInfo;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuFactory {
    private static final Logger log = LoggerFactory.getLogger(MenuFactory.class);
    public static final String THREADS = "menu_threads";
    public static final String FRAGMENTS = "menu_fragments";
    public static final String TIMERS = "menu_timer";
    public static final String CONTROLLERS = "menu_logic_controller";
    public static final String SAMPLERS = "menu_generative_controller";
    public static final String CONFIG_ELEMENTS = "menu_config_element";
    public static final String POST_PROCESSORS = "menu_post_processors";
    public static final String PRE_PROCESSORS = "menu_pre_processors";
    public static final String ASSERTIONS = "menu_assertions";
    public static final String NON_TEST_ELEMENTS = "menu_non_test_elements";
    public static final String LISTENERS = "menu_listener";
    private static final Map<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();
    private static final Set<String> elementsToSkip = new HashSet<String>();
    private static final String[] MENU_ADD_CONTROLLER = new String[]{"menu_logic_controller", "menu_config_element", "menu_timer", "menu_pre_processors", "menu_generative_controller", "menu_post_processors", "menu_assertions", "menu_listener"};
    private static final String[] MENU_PARENT_CONTROLLER = new String[]{"menu_logic_controller"};
    private static final String[] MENU_ADD_SAMPLER = new String[]{"menu_config_element", "menu_timer", "menu_pre_processors", "menu_post_processors", "menu_assertions", "menu_listener"};
    private static final String[] MENU_PARENT_SAMPLER = new String[]{"menu_logic_controller"};
    private static final List<MenuInfo> timers;
    private static final List<MenuInfo> controllers;
    private static final List<MenuInfo> samplers;
    private static final List<MenuInfo> threads;
    private static final List<MenuInfo> fragments;
    private static final List<MenuInfo> configElements;
    private static final List<MenuInfo> assertions;
    private static final List<MenuInfo> listeners;
    private static final List<MenuInfo> nonTestElements;
    private static final List<MenuInfo> postProcessors;
    private static final List<MenuInfo> preProcessors;

    private MenuFactory() {
    }

    public static void addEditMenu(JPopupMenu menu, boolean removable) {
        MenuFactory.addSeparator(menu);
        if (removable) {
            menu.add(MenuFactory.makeMenuItemRes("cut", "Cut", KeyStrokes.CUT));
        }
        menu.add(MenuFactory.makeMenuItemRes("copy", "Copy", KeyStrokes.COPY));
        menu.add(MenuFactory.makeMenuItemRes("paste", "Paste", KeyStrokes.PASTE));
        menu.add(MenuFactory.makeMenuItemRes("duplicate", "duplicate", KeyStrokes.DUPLICATE));
        if (removable) {
            menu.add(MenuFactory.makeMenuItemRes("remove", "remove", KeyStrokes.REMOVE));
        }
    }

    public static void addPasteResetMenu(JPopupMenu menu) {
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItemRes("paste", "Paste", KeyStrokes.PASTE));
    }

    public static void addFileMenu(JPopupMenu pop) {
        MenuFactory.addFileMenu(pop, true);
    }

    public static void addFileMenu(JPopupMenu menu, boolean addSaveTestFragmentMenu) {
        if (UndoHistory.isEnabled()) {
            MenuFactory.addUndoItems(menu);
        }
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItemRes("open", "open"));
        menu.add(MenuFactory.makeMenuItemRes("menu_merge", "merge"));
        menu.add(MenuFactory.makeMenuItemRes("save_as", "save_as"));
        if (addSaveTestFragmentMenu) {
            menu.add(MenuFactory.makeMenuItemRes("save_as_test_fragment", "save_as_test_fragment"));
        }
        MenuFactory.addSeparator(menu);
        JMenuItem savePicture = MenuFactory.makeMenuItemRes("save_as_image", "save_graphics", KeyStrokes.SAVE_GRAPHICS);
        menu.add(savePicture);
        if (!(GuiPackage.getInstance().getCurrentGui() instanceof Printable)) {
            savePicture.setEnabled(false);
        }
        JMenuItem savePictureAll = MenuFactory.makeMenuItemRes("save_as_image_all", "save_graphics_all", KeyStrokes.SAVE_GRAPHICS_ALL);
        menu.add(savePictureAll);
        MenuFactory.addSeparator(menu);
        JMenuItem disabled = MenuFactory.makeMenuItemRes("disable", "disable");
        JMenuItem enabled = MenuFactory.makeMenuItemRes("enable", "enable");
        boolean isEnabled = GuiPackage.getInstance().getTreeListener().getCurrentNode().isEnabled();
        if (isEnabled) {
            disabled.setEnabled(true);
            enabled.setEnabled(false);
        } else {
            disabled.setEnabled(false);
            enabled.setEnabled(true);
        }
        menu.add(enabled);
        menu.add(disabled);
        JMenuItem toggle = MenuFactory.makeMenuItemRes("toggle", "toggle", KeyStrokes.TOGGLE);
        menu.add(toggle);
        MenuFactory.addSeparator(menu);
        menu.add(MenuFactory.makeMenuItemRes("help", "help"));
    }

    private static void addUndoItems(JPopupMenu menu) {
        MenuFactory.addSeparator(menu);
        JMenuItem undo = MenuFactory.makeMenuItemRes("undo", "undo");
        undo.setEnabled(GuiPackage.getInstance().canUndo());
        menu.add(undo);
        JMenuItem redo = MenuFactory.makeMenuItemRes("redo", "redo");
        redo.setEnabled(GuiPackage.getInstance().canRedo());
        menu.add(redo);
    }

    public static JMenu makeMenus(String[] categories, String label, String actionCommand) {
        JMenu addMenu = new JMenu(label);
        for (String category : categories) {
            addMenu.add(MenuFactory.makeMenu(category, actionCommand));
        }
        GuiUtils.makeScrollableMenu((JMenu)addMenu);
        return addMenu;
    }

    public static JPopupMenu getDefaultControllerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(MENU_ADD_CONTROLLER, JMeterUtils.getResString("add"), "Add"));
        pop.add(MenuFactory.makeMenuItemRes("add_think_times", "Add Think Time between each step"));
        pop.add(MenuFactory.makeMenuItemRes("apply_naming", "Apply Naming Convention"));
        pop.add(MenuFactory.makeMenus(MENU_PARENT_CONTROLLER, JMeterUtils.getResString("change_parent"), "Change Parent"));
        pop.add(MenuFactory.makeMenus(MENU_PARENT_CONTROLLER, JMeterUtils.getResString("insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultSamplerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(MENU_ADD_SAMPLER, JMeterUtils.getResString("add"), "Add"));
        pop.add(MenuFactory.makeMenus(MENU_PARENT_SAMPLER, JMeterUtils.getResString("insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultConfigElementMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultVisualizerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenuItemRes("clear", "action.clear"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultTimerMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultAssertionMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultExtractorMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JPopupMenu getDefaultMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public static JMenu makeMenu(String category, String actionCommand) {
        return MenuFactory.makeMenu((Collection<MenuInfo>)menuMap.get(category), actionCommand, JMeterUtils.getResString(category));
    }

    public static JMenu makeMenu(Collection<MenuInfo> menuInfo, String actionCommand, String menuName) {
        JMenu menu = new JMenu(menuName);
        for (MenuInfo info : menuInfo) {
            menu.add(MenuFactory.makeMenuItem(info, actionCommand));
        }
        GuiUtils.makeScrollableMenu((JMenu)menu);
        return menu;
    }

    public static void setEnabled(JMenu menu) {
        if (menu.getSubElements().length == 0) {
            menu.setEnabled(false);
        }
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(label);
        newMenuChoice.setName(name);
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    public static JMenuItem makeMenuItemRes(String resource, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(JMeterUtils.getResString(resource));
        newMenuChoice.setName(resource);
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    public static Component makeMenuItem(MenuInfo info, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(info.getLabel());
        newMenuChoice.setName(info.getClassName());
        newMenuChoice.addActionListener(ActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    public static JMenuItem makeMenuItemRes(String resource, String actionCommand, KeyStroke accel) {
        JMenuItem item = MenuFactory.makeMenuItemRes(resource, actionCommand);
        item.setAccelerator(accel);
        return item;
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand, KeyStroke accel) {
        JMenuItem item = MenuFactory.makeMenuItem(label, name, actionCommand);
        item.setAccelerator(accel);
        return item;
    }

    private static void initializeMenus() {
        try {
            List guiClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{JMeterGUIComponent.class, TestBean.class});
            Collections.sort(guiClasses);
            for (String name : guiClasses) {
                if (name.endsWith("JMeterTreeNode") || name.endsWith("TestBeanGUI")) continue;
                if (elementsToSkip.contains(name)) {
                    log.info("Skipping {}", (Object)name);
                    continue;
                }
                boolean hideBean = false;
                JMeterGUIComponent item = null;
                try {
                    Class<?> c = Class.forName(name);
                    if (TestBean.class.isAssignableFrom(c)) {
                        TestBeanGUI tbgui = new TestBeanGUI(c);
                        hideBean = tbgui.isHidden() || tbgui.isExpert() && !JMeterUtils.isExpertMode();
                        item = tbgui;
                    } else {
                        item = (JMeterGUIComponent)c.newInstance();
                    }
                }
                catch (NoClassDefFoundError e) {
                    log.warn("Configuration error, probably corrupt or missing third party library(jar) ? Could not create class: {}. {}", new Object[]{name, e, e});
                    continue;
                }
                catch (HeadlessException e) {
                    log.warn("Could not instantiate class: {}", (Object)name, (Object)e);
                    continue;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.warn("Could not instantiate class: {}", (Object)name, (Object)e);
                    continue;
                }
                if (hideBean || elementsToSkip.contains(item.getStaticLabel())) {
                    log.info("Skipping {}", (Object)name);
                    continue;
                }
                elementsToSkip.add(name);
                Collection<String> categories = item.getMenuCategories();
                if (categories == null) {
                    log.debug("{} participates in no menus.", (Object)name);
                    continue;
                }
                if (categories.contains(THREADS)) {
                    threads.add(new MenuInfo(item, name));
                }
                if (categories.contains(FRAGMENTS)) {
                    fragments.add(new MenuInfo(item, name));
                }
                if (categories.contains(TIMERS)) {
                    timers.add(new MenuInfo(item, name));
                }
                if (categories.contains(POST_PROCESSORS)) {
                    postProcessors.add(new MenuInfo(item, name));
                }
                if (categories.contains(PRE_PROCESSORS)) {
                    preProcessors.add(new MenuInfo(item, name));
                }
                if (categories.contains(CONTROLLERS)) {
                    controllers.add(new MenuInfo(item, name));
                }
                if (categories.contains(SAMPLERS)) {
                    samplers.add(new MenuInfo(item, name));
                }
                if (categories.contains(NON_TEST_ELEMENTS)) {
                    nonTestElements.add(new MenuInfo(item, name));
                }
                if (categories.contains(LISTENERS)) {
                    listeners.add(new MenuInfo(item, name));
                }
                if (categories.contains(CONFIG_ELEMENTS)) {
                    configElements.add(new MenuInfo(item, name));
                }
                if (!categories.contains(ASSERTIONS)) continue;
                assertions.add(new MenuInfo(item, name));
            }
        }
        catch (IOException e) {
            log.error("IO Exception while initializing menus.", (Throwable)e);
        }
    }

    private static void addSeparator(JPopupMenu menu) {
        MenuElement[] elements = menu.getSubElements();
        if (elements.length > 0 && !(elements[elements.length - 1] instanceof JPopupMenu.Separator)) {
            menu.addSeparator();
        }
    }

    public static boolean canAddTo(JMeterTreeNode parentNode, TestElement element) {
        JMeterTreeNode node = new JMeterTreeNode(element, null);
        return MenuFactory.canAddTo(parentNode, new JMeterTreeNode[]{node});
    }

    public static boolean canAddTo(JMeterTreeNode parentNode, JMeterTreeNode[] nodes) {
        if (null == parentNode) {
            return false;
        }
        if (MenuFactory.foundClass(nodes, new Class[]{WorkBench.class})) {
            return false;
        }
        if (MenuFactory.foundClass(nodes, new Class[]{TestPlan.class})) {
            return false;
        }
        TestElement parent = parentNode.getTestElement();
        if (MenuFactory.foundClass(nodes, new Class[]{TestFragmentController.class})) {
            return parent instanceof TestPlan;
        }
        if (parent instanceof WorkBench) {
            return true;
        }
        if (parent instanceof TestPlan) {
            return !MenuFactory.foundClass(nodes, new Class[]{Sampler.class, Controller.class}, AbstractThreadGroup.class);
        }
        if (MenuFactory.foundClass(nodes, new Class[]{AbstractThreadGroup.class})) {
            return false;
        }
        if (parent instanceof Controller) {
            return true;
        }
        if (parent instanceof Sampler) {
            return !MenuFactory.foundClass(nodes, new Class[]{Sampler.class, Controller.class});
        }
        return false;
    }

    private static boolean foundClass(JMeterTreeNode[] nodes, Class<?>[] classes) {
        for (JMeterTreeNode node : nodes) {
            for (Class<?> aClass : classes) {
                if (!aClass.isInstance(node.getUserObject())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean foundClass(JMeterTreeNode[] nodes, Class<?>[] classes, Class<?> except) {
        for (JMeterTreeNode node : nodes) {
            Object userObject = node.getUserObject();
            if (except.isInstance(userObject)) continue;
            for (Class<?> aClass : classes) {
                if (!aClass.isInstance(userObject)) continue;
                return true;
            }
        }
        return false;
    }

    static int menuMap_size() {
        return menuMap.size();
    }

    static int assertions_size() {
        return assertions.size();
    }

    static int configElements_size() {
        return configElements.size();
    }

    static int controllers_size() {
        return controllers.size();
    }

    static int listeners_size() {
        return listeners.size();
    }

    static int nonTestElements_size() {
        return nonTestElements.size();
    }

    static int postProcessors_size() {
        return postProcessors.size();
    }

    static int preProcessors_size() {
        return preProcessors.size();
    }

    static int samplers_size() {
        return samplers.size();
    }

    static int timers_size() {
        return timers.size();
    }

    static int elementsToSkip_size() {
        return elementsToSkip.size();
    }

    private static void sortPluginMenus() {
        for (Map.Entry<String, List<MenuInfo>> me : menuMap.entrySet()) {
            Collections.sort(me.getValue(), new MenuInfoComparator(!me.getKey().equals(THREADS)));
        }
    }

    static {
        threads = new LinkedList<MenuInfo>();
        fragments = new LinkedList<MenuInfo>();
        timers = new LinkedList<MenuInfo>();
        controllers = new LinkedList<MenuInfo>();
        samplers = new LinkedList<MenuInfo>();
        configElements = new LinkedList<MenuInfo>();
        assertions = new LinkedList<MenuInfo>();
        listeners = new LinkedList<MenuInfo>();
        postProcessors = new LinkedList<MenuInfo>();
        preProcessors = new LinkedList<MenuInfo>();
        nonTestElements = new LinkedList<MenuInfo>();
        menuMap.put(THREADS, threads);
        menuMap.put(FRAGMENTS, fragments);
        menuMap.put(TIMERS, timers);
        menuMap.put(ASSERTIONS, assertions);
        menuMap.put(CONFIG_ELEMENTS, configElements);
        menuMap.put(CONTROLLERS, controllers);
        menuMap.put(LISTENERS, listeners);
        menuMap.put(NON_TEST_ELEMENTS, nonTestElements);
        menuMap.put(SAMPLERS, samplers);
        menuMap.put(POST_PROCESSORS, postProcessors);
        menuMap.put(PRE_PROCESSORS, preProcessors);
        try {
            String[] classesToSkip;
            for (String aClassesToSkip : classesToSkip = JOrphanUtils.split((String)JMeterUtils.getPropDefault("not_in_menu", ""), (String)",")) {
                elementsToSkip.add(aClassesToSkip.trim());
            }
            MenuFactory.initializeMenus();
            MenuFactory.sortPluginMenus();
        }
        catch (Error | RuntimeException ex) {
            log.error("Error initializing menus in static bloc, check configuration if using 3rd party libraries", ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error initializing menus in static bloc, check configuration if using 3rd party libraries", (Throwable)ex);
        }
    }

    private static class MenuInfoComparator
    implements Comparator<MenuInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean caseBlind;

        MenuInfoComparator(boolean caseBlind) {
            this.caseBlind = caseBlind;
        }

        @Override
        public int compare(MenuInfo o1, MenuInfo o2) {
            String lab1 = o1.getLabel();
            String lab2 = o2.getLabel();
            if (this.caseBlind) {
                return lab1.toLowerCase(Locale.ENGLISH).compareTo(lab2.toLowerCase(Locale.ENGLISH));
            }
            return lab1.compareTo(lab2);
        }
    }
}

