/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.Searcher;

public class RegexpSearcher
implements Searcher {
    private boolean caseSensitive;
    private Pattern pattern;

    public RegexpSearcher(boolean caseSensitive, String regexp) {
        this.caseSensitive = caseSensitive;
        this.pattern = caseSensitive ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
    }

    @Override
    public boolean search(List<String> textTokens) {
        for (String searchableToken : textTokens) {
            Matcher matcher;
            if (StringUtils.isEmpty((CharSequence)searchableToken) || !(matcher = this.caseSensitive ? this.pattern.matcher(searchableToken) : this.pattern.matcher(searchableToken.toLowerCase())).find()) continue;
            return true;
        }
        return false;
    }
}

