/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class VersionTest
extends AbstractVersionTest {
    private VersionManager versionManager;
    private Version version;
    private Version version2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        this.version = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.checkout(this.versionableNode.getPath());
        this.version2 = this.versionManager.checkin(this.versionableNode.getPath());
    }

    @Override
    protected void tearDown() throws Exception {
        this.versionManager.checkout(this.versionableNode.getPath());
        this.version = null;
        this.version2 = null;
        super.tearDown();
    }

    public void testAccept() throws Exception {
        ItemVisitorTest ivt = new ItemVisitorTest(this.version);
        this.version.accept((ItemVisitor)ivt);
    }

    public void testAddMixin() throws Exception {
        try {
            this.version.addMixin(this.mixVersionable);
            VersionTest.fail((String)"Version should be read-only: Version.addMixin(String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testAddNode() throws Exception {
        try {
            this.version.addNode(this.nodeName4);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.addNode(String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.addNode(this.nodeName4, this.ntBase);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.addNode(String,String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testCanAddMixin() throws Exception {
        VersionTest.assertFalse((String)"Version should be read-only: Version.canAddMixin(String) returned true", (boolean)this.version.canAddMixin(this.mixVersionable));
    }

    public void testCancelMerge() throws Exception {
        try {
            this.version.cancelMerge(this.version2);
            VersionTest.fail((String)"Version.cancelMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCancelMergeJcr2() throws Exception {
        try {
            this.versionManager.cancelMerge(this.version.getPath(), this.version2);
            VersionTest.fail((String)"Version.cancelMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckin() throws Exception {
        try {
            this.version.checkin();
            VersionTest.fail((String)"Version.checkin() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckinJcr2() throws Exception {
        try {
            this.versionManager.checkin(this.version.getPath());
            VersionTest.fail((String)"Version.checkin() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckout() throws Exception {
        try {
            this.version.checkout();
            VersionTest.fail((String)"Version.checkout() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckoutJcr2() throws Exception {
        try {
            this.versionManager.checkout(this.version.getPath());
            VersionTest.fail((String)"Version.checkout() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testDoneMerge() throws Exception {
        try {
            this.version.doneMerge(this.version2);
            VersionTest.fail((String)"Version should not be versionable: Version.doneMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testDoneMergeJcr2() throws Exception {
        try {
            this.versionManager.doneMerge(this.version.getPath(), this.version2);
            VersionTest.fail((String)"Version should not be versionable: Version.doneMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetAncestor() throws Exception {
        VersionTest.assertTrue((String)"Version.getAncestor(int) does not work", (boolean)this.superuser.getRootNode().isSame(this.version.getAncestor(0)));
    }

    public void testGetBaseVersion() throws Exception {
        try {
            this.version.getBaseVersion();
            VersionTest.fail((String)"Version.getBaseVersion() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetBaseVersionJcr2() throws Exception {
        try {
            this.versionManager.getBaseVersion(this.version.getPath());
            VersionTest.fail((String)"Version.getBaseVersion() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetCorrespondingNodePath() throws Exception {
        VersionTest.assertEquals((String)"Version.getCorrespondingNodePath(String) did not return the right path", (String)this.version.getPath(), (String)this.version.getCorrespondingNodePath(this.workspaceName));
    }

    public void testGetDepth() throws Exception {
        VersionTest.assertTrue((String)"Version.getDepth() mismatch", (this.version.getDepth() >= 4 ? 1 : 0) != 0);
    }

    public void testGetIndex() throws Exception {
        VersionTest.assertEquals((String)"Version.getIndex() mismatch", (int)1, (int)this.version.getIndex());
    }

    public void testGetLock() throws Exception {
        try {
            this.version.getLock();
            VersionTest.fail((String)"Version should not be lockable: Version.getLock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testGetLockJcr2() throws Exception {
        try {
            this.version.getSession().getWorkspace().getLockManager().getLock(this.version.getPath());
            VersionTest.fail((String)"Version should not be lockable: Version.getLock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testGetMixinNodeTypes() throws Exception {
        NodeType[] ntArray = this.version.getMixinNodeTypes();
        VersionTest.assertNotNull((String)"Version.getMixinNodeTypes returns null array", (Object)ntArray);
    }

    public void testGetName() throws Exception {
        VersionTest.assertTrue((String)"Version.getName() does not return the right name", (boolean)this.versionableNode.getVersionHistory().getVersion(this.version.getName()).isSame((Item)this.version));
    }

    public void testGetNode() throws Exception {
        VersionTest.assertTrue((String)"Version.getNode(String) does not return a sub-node of type nt:frozenNode", (boolean)this.version.getNode(this.jcrFrozenNode).isNodeType(this.ntFrozenNode));
    }

    public void testGetNodes() throws Exception {
        VersionTest.assertTrue((String)"Version.getNodes() does not return a sub-node of type nt:frozenNode", (boolean)this.version.getNodes().nextNode().isNodeType(this.ntFrozenNode));
        VersionTest.assertTrue((String)"Version.getNodes(String) does not return a sub-node of type nt:frozenNode", (boolean)this.version.getNodes(this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":*").nextNode().isNodeType(this.ntFrozenNode));
    }

    public void testGetParent() throws Exception {
        VersionTest.assertTrue((String)"Version.getParent() does not return a parent-node of type nt:versionHistory", (boolean)this.version.getParent().isNodeType(this.ntVersionHistory));
    }

    public void testGetPath() throws Exception {
        VersionTest.assertTrue((String)"Version.getPath() does not return the right path", (boolean)this.version.getPath().startsWith("/" + this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":system/" + this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":versionStorage/"));
    }

    public void testGetPrimaryItem() throws Exception {
        try {
            this.version.getPrimaryItem();
            VersionTest.fail((String)"Version.getPrimaryItem() did not throw a ItemNotFoundException");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetPrimaryNodeType() throws Exception {
        VersionTest.assertEquals((String)"Version does not have the primary node type nt:version", (String)this.ntVersion, (String)this.version.getPrimaryNodeType().getName());
    }

    public void testGetProperties() throws Exception {
        PropertyIterator pi = this.version.getProperties();
        boolean hasPropertyCreated = false;
        while (pi.hasNext()) {
            if (!pi.nextProperty().getName().equals(this.jcrCreated)) continue;
            hasPropertyCreated = true;
        }
        VersionTest.assertTrue((String)"Version.getProperties() does not return property jcr:created", (boolean)hasPropertyCreated);
        pi = this.version.getProperties(this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":*");
        hasPropertyCreated = false;
        while (pi.hasNext()) {
            if (!pi.nextProperty().getName().equals(this.jcrCreated)) continue;
            hasPropertyCreated = true;
        }
        VersionTest.assertTrue((String)"Version.getProperties(String) does not return property jcr:created", (boolean)hasPropertyCreated);
    }

    public void testGetProperty() throws Exception {
        VersionTest.assertTrue((String)"Version.getProperty(String) does not return property jcr:created", (boolean)this.version.getProperty(this.jcrCreated).getName().equals(this.jcrCreated));
    }

    public void testGetSession() throws Exception {
        VersionTest.assertSame((String)"Version.getSession() did not return the right session", (Object)this.superuser, (Object)this.version.getSession());
    }

    public void testGetVersionHistory() throws Exception {
        try {
            this.version.getVersionHistory();
            VersionTest.fail((String)"Version.getVersionHistory() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetVersionHistoryJcr2() throws Exception {
        try {
            this.versionManager.getVersionHistory(this.version.getPath());
            VersionTest.fail((String)"Version.getVersionHistory() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetUUID() throws Exception {
        List<Value> successorValues = Arrays.asList(this.versionableNode.getVersionHistory().getRootVersion().getProperty(this.jcrSuccessors).getValues());
        VersionTest.assertTrue((String)"Version.getUUID() did not return the right UUID", (boolean)successorValues.contains(this.superuser.getValueFactory().createValue((Node)this.version)));
    }

    public void testHasNode() throws Exception {
        VersionTest.assertTrue((String)"Version.hasNode(String) did not return true", (boolean)this.version.hasNode(this.jcrFrozenNode));
    }

    public void testHasNodes() throws Exception {
        VersionTest.assertTrue((String)"Version.hasNodes() did not return true", (boolean)this.version.hasNodes());
    }

    public void testHasProperties() throws Exception {
        VersionTest.assertTrue((String)"Version.hasProperties() did not return true", (boolean)this.version.hasProperties());
    }

    public void testHasProperty() throws Exception {
        VersionTest.assertTrue((String)"Version.hasProperty(String) did not return true", (boolean)this.version.hasProperty(this.jcrCreated));
    }

    public void testHoldsLock() throws Exception {
        VersionTest.assertFalse((String)"Version.holdsLock() did not return false", (boolean)this.version.holdsLock());
    }

    public void testHoldsLockJcr2() throws Exception {
        VersionTest.assertFalse((String)"Version.holdsLock() did not return false", (boolean)this.version.getSession().getWorkspace().getLockManager().holdsLock(this.version.getPath()));
    }

    public void testIsCheckedOut() throws Exception {
        VersionTest.assertTrue((String)"Version.isCheckedOut() did not return true", (boolean)this.version.isCheckedOut());
    }

    public void testIsCheckedOutJcr2() throws Exception {
        VersionTest.assertTrue((String)"Version.isCheckedOut() did not return true", (boolean)this.versionManager.isCheckedOut(this.version.getPath()));
    }

    public void testIsLocked() throws Exception {
        VersionTest.assertFalse((String)"Version.isLocked() did not return false", (boolean)this.version.isLocked());
    }

    public void testIsLockedJcr2() throws Exception {
        VersionTest.assertFalse((String)"Version.isLocked() did not return false", (boolean)this.version.getSession().getWorkspace().getLockManager().isLocked(this.version.getPath()));
    }

    public void testIsModified() throws Exception {
        VersionTest.assertFalse((String)"Version.isModified() did not return false", (boolean)this.version.isModified());
    }

    public void testIsNew() throws Exception {
        VersionTest.assertFalse((String)"Version.isNew() did not return false", (boolean)this.version.isNew());
    }

    public void testIsNode() throws Exception {
        VersionTest.assertTrue((String)"Version.isNode() did not return true", (boolean)this.version.isNode());
    }

    public void testIsNodeType() throws Exception {
        VersionTest.assertTrue((String)"Version.isNodeType(String) did not return true for nt:version", (boolean)this.version.isNodeType(this.ntVersion));
    }

    public void testIsSame() throws Exception {
        VersionTest.assertTrue((String)"Version.isSame(Item) did not return true", (boolean)this.version2.isSame((Item)this.versionableNode.getBaseVersion()));
    }

    public void testIsSameJcr2() throws Exception {
        VersionTest.assertTrue((String)"Version.isSame(Item) did not return true", (boolean)this.version2.isSame((Item)this.versionManager.getBaseVersion(this.versionableNode.getPath())));
    }

    public void testLock() throws Exception {
        try {
            this.version.lock(true, true);
            VersionTest.fail((String)"Version should not be lockable: Version.lock(true,true) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            this.version.lock(true, false);
            VersionTest.fail((String)"Version should not be lockable: Version.lock(true,false) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            this.version.lock(false, true);
            VersionTest.fail((String)"Version should not be lockable: Version.lock(false,true) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            this.version.lock(false, false);
            VersionTest.fail((String)"Version should not be lockable: Version.lock(false,false) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testLockJcr2() throws Exception {
        LockManager lockManager = this.version.getSession().getWorkspace().getLockManager();
        String path = this.version.getPath();
        try {
            lockManager.lock(path, true, true, 60L, "");
            VersionTest.fail((String)"Version should not be lockable: Version.lock(true,true) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            lockManager.lock(path, true, false, 60L, "");
            VersionTest.fail((String)"Version should not be lockable: Version.lock(true,false) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            lockManager.lock(path, false, true, 60L, "");
            VersionTest.fail((String)"Version should not be lockable: Version.lock(false,true) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            lockManager.lock(path, false, false, 60L, "");
            VersionTest.fail((String)"Version should not be lockable: Version.lock(false,false) did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testMerge() throws Exception {
        try {
            this.version.merge(this.workspaceName, true);
            VersionTest.fail((String)"Version.merge(String, true) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.merge(this.workspaceName, false);
            VersionTest.fail((String)"Version.merge(String, false) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testOrderBefore() throws Exception {
        try {
            this.version.orderBefore(this.jcrFrozenNode, null);
            VersionTest.fail((String)"Version.orderBefore(String,String) did not throw an UnsupportedRepositoryOperationException or a ConstraintViolationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRefresh() throws Exception {
        this.version.refresh(true);
        this.version.refresh(false);
    }

    public void testRemove() throws Exception {
        try {
            this.version.remove();
            this.versionableNode.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.remove() did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRemoveMixin() throws Exception {
        try {
            this.version.removeMixin(this.mixVersionable);
            VersionTest.fail((String)"Version should be read-only: Version.removeMixin(String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRestore() throws Exception {
        try {
            this.version.restore("abc", true);
            VersionTest.fail((String)"Version.restore(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
        try {
            this.version.restore(this.version2, true);
            VersionTest.fail((String)"Version.restore(Version,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
        try {
            this.version.restore(this.version2, "abc", true);
            VersionTest.fail((String)"Version.restore(Version,String,boolean) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRestoreJcr2() throws Exception {
        try {
            this.versionManager.restore(this.version.getPath(), "abc", true);
            VersionTest.fail((String)"Version.restore(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreByLabel() throws Exception {
        try {
            this.version.restoreByLabel("abc", true);
            VersionTest.fail((String)"Version.restoreByLabel(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreByLabelJcr2() throws Exception {
        try {
            this.versionManager.restoreByLabel(this.version.getPath(), "abc", true);
            VersionTest.fail((String)"Version.restoreByLabel(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testSetProperty() throws Exception {
        Value[] vArray = new Value[]{this.superuser.getValueFactory().createValue("abc"), this.superuser.getValueFactory().createValue("xyz"), this.superuser.getValueFactory().createValue("123")};
        String[] s = new String[]{"abc", "xyz", "123"};
        try {
            this.version.setProperty(this.propertyName1, s);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,String[]) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, s, 1);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,String[],int) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, vArray);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,Value[]) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, vArray, 1);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,Value[],int]) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, true);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,boolean) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, 123L);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,double) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            byte[] bytes = new byte[]{73, 26, 32, -36, 40, -43, -124};
            ByteArrayInputStream inpStream = new ByteArrayInputStream(bytes);
            this.version.setProperty(this.propertyName1, (InputStream)inpStream);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,InputStream) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException bytes) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, "abc");
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException bytes) {
            // empty catch block
        }
        try {
            GregorianCalendar c = new GregorianCalendar(1945, 1, 6, 16, 20, 0);
            this.version.setProperty(this.propertyName1, (Calendar)c);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,Calendar) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException c) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, (Node)this.version);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,Node) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException c) {
            // empty catch block
        }
        try {
            Value v = this.superuser.getValueFactory().createValue("abc");
            this.version.setProperty(this.propertyName1, v);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,Value) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.version.setProperty(this.propertyName1, -2147483650L);
            this.version.getSession().save();
            VersionTest.fail((String)"Version should be read-only: Version.setProperty(String,long) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testUnlock() throws Exception {
        try {
            this.version.unlock();
            VersionTest.fail((String)"Version should not be lockable: Version.unlock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testUnlockJcr2() throws Exception {
        try {
            this.version.getSession().getWorkspace().getLockManager().unlock(this.version.getPath());
            VersionTest.fail((String)"Version should not be lockable: Version.unlock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testUpdate() throws Exception {
        try {
            this.version.update(this.workspaceName);
            VersionTest.fail((String)"VersionHistory.update(String) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testFrozenUUID() throws Exception {
        Property p = this.version.getNode(this.jcrFrozenNode).getProperty(this.jcrFrozenUuid);
        VersionTest.assertEquals((String)"jcr:fronzenUuid should be of type string", (String)"String", (String)PropertyType.nameFromValue((int)p.getType()));
    }

    private class ItemVisitorTest
    implements ItemVisitor {
        Node ivtNode;

        public ItemVisitorTest(Version v) {
            this.ivtNode = v;
        }

        public void visit(Node node) throws RepositoryException {
            Assert.assertTrue((String)"Version.accept(ItemVisitor) does not provide the right node to the ItemVisitor", (boolean)this.ivtNode.isSame((Item)node));
        }

        public void visit(Property property) throws RepositoryException {
        }
    }
}

