/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.lock;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.lock.AbstractLockTest;

public class DeepLockTest
extends AbstractLockTest {
    @Override
    protected boolean isSessionScoped() {
        return true;
    }

    @Override
    protected boolean isDeep() {
        return true;
    }

    public void testGetNodeOnLockObtainedFromChild() throws RepositoryException {
        Lock lock = this.childNode.getLock();
        DeepLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node even if lock is obtained from child node.", (boolean)lock.getNode().isSame((Item)this.lockedNode));
    }

    public void testGetNodeOnLockObtainedFromNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        Lock lock = newChild.getLock();
        DeepLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node even if lock is obtained from child node.", (boolean)lock.getNode().isSame((Item)this.lockedNode));
    }

    public void testParentChildDeepLock() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.childNode, this.mixLockable);
        this.testRootNode.getSession().save();
        try {
            this.childNode.lock(false, false);
            DeepLockTest.fail((String)"child node is already locked by deep lock on parent.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            this.lockMgr.lock(this.childNode.getPath(), false, false, this.getTimeoutHint(), this.getLockOwner());
            DeepLockTest.fail((String)"child node is already locked by deep lock on parent.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testDeepLockAboveLockedChild() throws RepositoryException, NotExecutableException {
        Node parent = this.lockedNode.getParent();
        if (!parent.isNodeType(this.mixLockable)) {
            try {
                this.ensureMixinType(parent, this.mixLockable);
                parent.save();
            }
            catch (RepositoryException e) {
                throw new NotExecutableException();
            }
        }
        try {
            parent.lock(true, true);
            DeepLockTest.fail((String)"Creating a deep lock on a parent of a locked node must fail.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
        try {
            this.lockMgr.lock(parent.getPath(), true, true, this.getTimeoutHint(), this.getLockOwner());
            DeepLockTest.fail((String)"Creating a deep lock on a parent of a locked node must fail.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShallowLockAboveLockedChild() throws RepositoryException, NotExecutableException {
        Node parent = this.lockedNode.getParent();
        this.ensureMixinType(parent, this.mixLockable);
        parent.save();
        try {
            parent.lock(false, true);
        }
        finally {
            parent.unlock();
        }
        try {
            this.lockMgr.lock(parent.getPath(), false, true, this.getTimeoutHint(), this.getLockOwner());
        }
        finally {
            parent.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLockedChild() throws RepositoryException {
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            Node child = (Node)otherSession.getItem(this.childNode.getPath());
            child.remove();
            otherSession.save();
            DeepLockTest.fail((String)"A node below a deeply locked node cannot be removed by another Session.");
        }
        catch (LockException lockException) {
        }
        finally {
            otherSession.logout();
        }
    }
}

