/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NamespaceRegistryTest
extends AbstractJCRTest {
    private static final String[] SYSTEM_PREFIXES = new String[]{"jcr", "nt", "mix", "sv"};
    private static final String TEST_PREFIX = "tst";
    private static final String TEST_URI = "http://www.apache.org/jackrabbit/test/namespaceRegistryTest";
    private NamespaceRegistry nsp;
    private String namespacePrefix;
    private String namespaceUri;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.nsp = this.superuser.getWorkspace().getNamespaceRegistry();
        this.namespacePrefix = this.getUnusedPrefix();
        this.namespaceUri = this.getUnusedURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (Arrays.asList(this.nsp.getPrefixes()).contains(this.namespacePrefix)) {
                this.nsp.unregisterNamespace(this.namespacePrefix);
            }
        }
        catch (NamespaceException e) {
            this.log.println("Unable to unregister name space with prefix " + this.namespacePrefix + ": " + e.toString());
        }
        finally {
            this.nsp = null;
            super.tearDown();
        }
    }

    public void testRegisterNamespaceExceptions() throws RepositoryException {
        try {
            this.nsp.registerNamespace("jcr", this.namespaceUri);
            NamespaceRegistryTest.fail((String)"Trying to register the namespace 'jcr' must throw a NamespaceException.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        try {
            this.nsp.registerNamespace("nt", this.namespaceUri);
            NamespaceRegistryTest.fail((String)"Trying to register the namespace 'nt' must throw a NamespaceException.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        try {
            this.nsp.registerNamespace("mix", this.namespaceUri);
            NamespaceRegistryTest.fail((String)"Trying to register the namespace 'mix' must throw a NamespaceException.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        try {
            this.nsp.registerNamespace("sv", this.namespaceUri);
            NamespaceRegistryTest.fail((String)"Trying to register the namespace 'sv' must throw a NamespaceException.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testRegisterNamespaceXmlExceptions() throws RepositoryException {
        try {
            this.nsp.registerNamespace("xml", this.namespaceUri);
            NamespaceRegistryTest.fail((String)"Trying to register the namespace 'xml' must throw a NamespaceException.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        try {
            this.nsp.registerNamespace("xml" + Math.floor(Math.random() * 999999.0), this.namespaceUri);
            NamespaceRegistryTest.fail((String)"Trying to register a namespace that starts with 'xml' must throw a NamespaceException.");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testRegisterNamespace() throws RepositoryException {
        Node created;
        this.nsp.registerNamespace(this.namespacePrefix, this.namespaceUri);
        NamespaceRegistryTest.assertEquals((String)"Namespace prefix was not registered.", (String)this.namespacePrefix, (String)this.nsp.getPrefix(this.namespaceUri));
        NamespaceRegistryTest.assertEquals((String)"Namespace URI was not registered.", (String)this.namespaceUri, (String)this.nsp.getURI(this.namespacePrefix));
        try {
            created = this.testRootNode.addNode(this.namespacePrefix + ":root");
            this.testRootNode.getSession().save();
        }
        catch (RepositoryException ex) {
            this.testRootNode.getSession().refresh(false);
            created = this.testRootNode.setProperty(this.namespacePrefix + ":root", "test");
            this.testRootNode.getSession().save();
        }
        this.testRootNode.getSession().getItem(created.getPath()).remove();
        this.testRootNode.getSession().save();
    }

    public void testUnregisterNamespaceExceptions() throws RepositoryException {
        for (int t = 0; t < SYSTEM_PREFIXES.length; ++t) {
            try {
                this.nsp.unregisterNamespace(SYSTEM_PREFIXES[t]);
                NamespaceRegistryTest.fail((String)("Trying to unregister " + SYSTEM_PREFIXES[t] + " must fail"));
                continue;
            }
            catch (NamespaceException namespaceException) {
                // empty catch block
            }
        }
        try {
            this.nsp.unregisterNamespace("ThisNamespaceIsNotCurrentlyRegistered");
            NamespaceRegistryTest.fail((String)"Trying to unregister an unused prefix must fail");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    private String getUnusedPrefix() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>(Arrays.asList(this.nsp.getPrefixes()));
        String prefix = TEST_PREFIX;
        int i = 0;
        while (prefixes.contains(prefix)) {
            prefix = prefix + i++;
        }
        return prefix;
    }

    private String getUnusedURI() throws RepositoryException {
        HashSet<String> uris = new HashSet<String>(Arrays.asList(this.nsp.getURIs()));
        String uri = TEST_URI;
        int i = 0;
        while (uris.contains(uri)) {
            uri = uri + i++;
        }
        return uri;
    }
}

