/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class LifecycleTest
extends AbstractJCRTest {
    private String path;
    private String transition;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.checkSupportedOption("option.lifecycle.supported");
        this.ensureKnowsNodeType(this.superuser, "{http://www.jcp.org/jcr/mix/1.0}lifecycle");
        this.path = this.getProperty("lifecycleNode");
        if (this.path == null) {
            this.path = this.testRoot + "/lifecycle";
        }
        this.transition = this.getProperty("lifecycleTransition");
        if (this.transition == null) {
            this.transition = "identity";
        }
    }

    public void testGetAllowedLifecycleTransitions() throws RepositoryException, NotExecutableException {
        Node node = this.superuser.getNode(this.path);
        try {
            String[] transitions = node.getAllowedLifecycleTransistions();
            LifecycleTest.assertNotNull((String)"Return value of getAllowedLifecycleTransitions is null", (Object)transitions);
            for (int i = 0; i < transitions.length; ++i) {
                if (!this.transition.equals(transitions[i])) continue;
                return;
            }
            LifecycleTest.fail((String)("Configured lifecycle transition \"" + this.transition + "\" is not among the allowed transitions from node " + this.path));
        }
        catch (UnsupportedRepositoryOperationException e) {
            LifecycleTest.fail((String)("Unable to get allowed lifecycle transitions for node " + this.path + ": " + e.getMessage()));
        }
    }

    public void testFollowLifecycleTransition() throws RepositoryException, NotExecutableException {
        Node node = this.superuser.getNode(this.path);
        try {
            node.followLifecycleTransition(this.transition);
        }
        catch (UnsupportedRepositoryOperationException e) {
            LifecycleTest.fail((String)("Unable to follow lifecycle transition \"" + this.transition + "\" for node " + this.path + ": " + e.getMessage()));
        }
        catch (InvalidLifecycleTransitionException e) {
            LifecycleTest.fail((String)("Unable to follow lifecycle transition \"" + this.transition + "\" for node " + this.path + ": " + e.getMessage()));
        }
    }
}

