/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class NodeMovedTest
extends AbstractObservationTest {
    private static final String SRC_ABS_PATH = "srcAbsPath";
    private static final String DEST_ABS_PATH = "destAbsPath";

    public void testMoveTree() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.getSession().save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        EventResult moveNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.addEventListener(moveNodeListener, 32);
        this.superuser.move(n1.getPath(), this.testRoot + "/" + this.nodeName3);
        this.testRootNode.getSession().save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        Event[] moved = moveNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.removeEventListener(moveNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName3}, new String[]{this.nodeName3 + "/" + this.nodeName2});
        this.checkNodeRemoved(removed, new String[]{this.nodeName1}, new String[]{this.nodeName1 + "/" + this.nodeName2});
        this.checkNodeMoved(moved, this.nodeName1, this.nodeName3);
    }

    public void testMoveNode() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.getSession().save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        EventResult moveNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.addEventListener(moveNodeListener, 32);
        this.superuser.move(n2.getPath(), this.testRoot + "/" + this.nodeName2);
        this.testRootNode.getSession().save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        Event[] moved = moveNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.removeEventListener(moveNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName2}, null);
        this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "/" + this.nodeName2}, null);
        this.checkNodeMoved(moved, this.nodeName1 + "/" + this.nodeName2, this.nodeName2);
    }

    public void testMoveWithRemove() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.getSession().save();
        EventResult addNodeListener = new EventResult(this.log);
        EventResult removeNodeListener = new EventResult(this.log);
        EventResult moveNodeListener = new EventResult(this.log);
        this.addEventListener(addNodeListener, 1);
        this.addEventListener(removeNodeListener, 2);
        this.addEventListener(moveNodeListener, 32);
        this.superuser.move(n2.getPath(), n3.getPath() + "/" + this.nodeName2);
        n1.remove();
        this.testRootNode.getSession().save();
        Event[] added = addNodeListener.getEvents(5000L);
        Event[] removed = removeNodeListener.getEvents(5000L);
        Event[] moved = moveNodeListener.getEvents(5000L);
        this.removeEventListener(addNodeListener);
        this.removeEventListener(removeNodeListener);
        this.removeEventListener(moveNodeListener);
        this.checkNodeAdded(added, new String[]{this.nodeName3 + "/" + this.nodeName2}, null);
        this.checkNodeRemoved(removed, new String[]{this.nodeName1 + "/" + this.nodeName2, this.nodeName1}, null);
        this.checkNodeMoved(moved, this.nodeName1 + "/" + this.nodeName2, this.nodeName3 + "/" + this.nodeName2);
    }

    protected void checkNodeMoved(Event[] events, String from, String to) throws RepositoryException {
        this.checkNodes(events, new String[]{to}, null, 32L);
        NodeMovedTest.assertEquals((String)"Wrong number of events", (int)1, (int)events.length);
        Map info = events[0].getInfo();
        this.checkInfoEntry(info, SRC_ABS_PATH, this.testRoot + "/" + from);
        this.checkInfoEntry(info, DEST_ABS_PATH, this.testRoot + "/" + to);
    }

    protected void checkInfoEntry(Map<?, ?> info, String key, String expected) {
        String value = (String)info.get(key);
        NodeMovedTest.assertNotNull((String)("Missing event info key: " + key), (Object)value);
        NodeMovedTest.assertEquals((String)("Wrong event info value for: " + key), (String)expected, (String)value);
    }
}

