/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class WorkspaceManagementTest
extends AbstractJCRTest {
    private Workspace workspace;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        super.checkSupportedOption("option.workspace.management.supported");
        this.workspace = this.superuser.getWorkspace();
    }

    public void testCreateWorkspace() throws RepositoryException {
        try {
            this.workspace.createWorkspace(this.workspaceName);
            WorkspaceManagementTest.fail((String)"creating a new workspace with the name of an already existing one must fail");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        this.workspace.createWorkspace("tmp" + System.currentTimeMillis());
        try {
            this.workspace.createWorkspace("tmp" + System.currentTimeMillis(), "unknownworkspace");
            WorkspaceManagementTest.fail((String)"NoSuchWorkspaceException expected");
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
        this.workspace.createWorkspace("tmp" + System.currentTimeMillis(), this.superuser.getWorkspace().getName());
    }

    public void testDeleteWorkspace() throws RepositoryException {
        try {
            this.workspace.deleteWorkspace("unknownworkspace");
            WorkspaceManagementTest.fail((String)"NoSuchWorkspaceException expected");
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }
}

