/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceReferenceableTest;

public class WorkspaceCloneReferenceableTest
extends AbstractWorkspaceReferenceableTest {
    public void testCloneNodesReferenceableNodesOriginalUUID() throws RepositoryException, NotExecutableException {
        this.addMixinReferenceableToNode(this.node1);
        String dstAbsPath = this.node2W2.getPath() + "/" + this.node1.getName();
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
        String originalUUID = this.node1.getUUID();
        Node copiedNode = this.node2W2.getNode(this.node1.getName());
        String copiedUUID = copiedNode.getUUID();
        WorkspaceCloneReferenceableTest.assertTrue((boolean)originalUUID.equals(copiedUUID));
    }

    public void testCloneNodesRemoveExistingTrue() throws RepositoryException, NotExecutableException {
        this.addMixinReferenceableToNode(this.node1);
        String dstAbsPath = this.node2W2.getPath() + "/" + this.nodeName2;
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
        Node clonedNode = this.node2W2.getNode(this.nodeName2);
        dstAbsPath = this.node2W2.getPath() + "/" + this.nodeName3;
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
        Node clonedNode2 = this.node2W2.getNode(this.nodeName3);
        WorkspaceCloneReferenceableTest.assertFalse((boolean)this.node2W2.hasNode(this.nodeName2));
    }

    public void testCloneNodesRemoveExistingFalse() throws RepositoryException, NotExecutableException {
        this.addMixinReferenceableToNode(this.node1);
        this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), this.testRootNodeW2.getPath() + "/" + this.nodeName3, false);
        try {
            this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), this.testRootNodeW2.getPath() + "/" + this.nodeName4, false);
            WorkspaceCloneReferenceableTest.fail((String)"If removeExisting is false then a UUID collision should throw a ItemExistsException");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testCloneNodesReferenceableAndNonreferenceable() throws RepositoryException, NotExecutableException {
        this.addMixinReferenceableToNode(this.node1);
        if (this.node1.isNodeType(this.mixReferenceable)) {
            this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), this.testRootNodeW2.getPath() + "/" + this.nodeName3, false);
        } else {
            WorkspaceCloneReferenceableTest.fail((String)"Node should be referenceable.");
        }
        if (this.node2.isNodeType(this.mixReferenceable)) {
            WorkspaceCloneReferenceableTest.fail((String)"Node should not be referenceable.");
        } else {
            this.workspaceW2.clone(this.workspace.getName(), this.node2.getPath(), this.testRootNodeW2.getPath() + "/" + this.nodeName4, false);
            WorkspaceCloneReferenceableTest.assertTrue((boolean)this.testRootNodeW2.hasNode(this.nodeName4));
        }
    }
}

