/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class PathTest
extends AbstractJCRTest {
    private String identifier;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.identifier = this.testRootNode.getIdentifier();
    }

    public void testGetItem() throws RepositoryException {
        Item item = this.superuser.getItem("[" + this.identifier + "]");
        PathTest.assertTrue((boolean)item.isSame((Item)this.testRootNode));
    }

    public void testCreatePathValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value pathValue = vf.createValue("[" + this.identifier + "]", 8);
        PathTest.assertEquals((int)8, (int)pathValue.getType());
        PathTest.assertEquals((String)("[" + this.identifier + "]"), (String)pathValue.getString());
        PathTest.assertFalse((boolean)pathValue.equals(vf.createValue(this.testRootNode.getPath(), 8)));
    }

    public void testCreateMultiplePathValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value vID1 = vf.createValue("[" + this.identifier + "]", 8);
        Value v = vf.createValue(this.testRootNode.getPath(), 8);
        Value vID2 = vf.createValue("[" + this.identifier + "]", 8);
        Value v2 = vf.createValue(this.testRootNode.getPath(), 8);
        PathTest.assertEquals((Object)vID1, (Object)vID2);
        PathTest.assertEquals((Object)v, (Object)v2);
        PathTest.assertFalse((boolean)v.equals(vID1));
        PathTest.assertFalse((boolean)v.equals(vID2));
    }

    public void testIdentifierBasedPropertyValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value pathValue = vf.createValue("[" + this.identifier + "]", 8);
        Property p = this.testRootNode.setProperty(this.propertyName1, pathValue);
        PathTest.assertEquals((int)8, (int)p.getType());
        PathTest.assertEquals((String)pathValue.getString(), (String)p.getValue().getString());
        PathTest.assertEquals((Object)pathValue, (Object)p.getValue());
    }

    public void testResolvedIdentifierBasedPropertyValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value pathValue = vf.createValue("[" + this.identifier + "]", 8);
        Property p = this.testRootNode.setProperty(this.propertyName1, pathValue);
        PathTest.assertTrue((String)"Identifier-based PATH value must resolve to the Node the identifier has been obtained from.", (boolean)this.testRootNode.isSame((Item)p.getNode()));
    }

    public void testExtendedNameBasedPathValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value pathValue = vf.createValue("/{http://www.jcp.org/jcr/1.0}system/{http://www.jcp.org/jcr/1.0}versionStorage", 8);
        Property p = this.testRootNode.setProperty(this.propertyName1, pathValue);
        PathTest.assertEquals((String)"/jcr:system/jcr:versionStorage", (String)p.getString());
        String path = "/{http://www.jcp.org/jcr/1.0}system/{http://www.jcp.org/jcr/1.0}versionStorage/a/b/c/jcr:frozenNode";
        pathValue = vf.createValue(path, 8);
        p = this.testRootNode.setProperty(this.propertyName1, pathValue);
        PathTest.assertEquals((String)"/jcr:system/jcr:versionStorage/a/b/c/jcr:frozenNode", (String)p.getString());
    }

    public void testNotNormalizedPathValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value pathValue = vf.createValue("/a/../b/./c/dd/..", 8);
        Property p = this.testRootNode.setProperty(this.propertyName1, pathValue);
        PathTest.assertEquals((int)8, (int)p.getType());
        PathTest.assertEquals((String)pathValue.getString(), (String)p.getValue().getString());
        PathTest.assertEquals((Object)pathValue, (Object)p.getValue());
    }
}

