/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jackrabbit.rmi.client.ClientAdapterFactory;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.SafeClientRepository;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;

public class RmiRepositoryFactory
implements RepositoryFactory {
    private static final String REPOSITORY_URI = "org.apache.jackrabbit.repository.uri";

    public Repository getRepository(Map parameters) throws RepositoryException {
        if (parameters != null && parameters.containsKey(REPOSITORY_URI)) {
            URI uri;
            try {
                uri = new URI(parameters.get(REPOSITORY_URI).toString().trim());
            }
            catch (URISyntaxException e) {
                return null;
            }
            String scheme = uri.getScheme();
            if ("rmi".equalsIgnoreCase(scheme)) {
                return this.getRmiRepository(uri.getSchemeSpecificPart());
            }
            if ("jndi".equalsIgnoreCase(scheme)) {
                Hashtable environment = new Hashtable(parameters);
                environment.remove(REPOSITORY_URI);
                return this.getJndiRepository(uri.getSchemeSpecificPart(), environment);
            }
            try {
                return this.getUrlRepository(uri.toURL());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    private Repository getUrlRepository(final URL url) throws RepositoryException {
        return new RmiSafeClientRepository(new ClientAdapterFactory()){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected RemoteRepository getRemoteRepository() throws RemoteException {
                try {
                    InputStream stream = url.openStream();
                    try {
                        Object remote = new ObjectInputStream(stream).readObject();
                        if (!(remote instanceof RemoteRepository)) throw new RemoteException("The resource at URL " + url + " is not a remote repository stub: " + remote);
                        RemoteRepository remoteRepository = (RemoteRepository)remote;
                        return remoteRepository;
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteException("The resource at URL " + url + " requires a class that is not available", e);
                }
                catch (IOException e) {
                    throw new RemoteException("Failed to read the resource at URL " + url, e);
                }
            }
        };
    }

    private Repository getJndiRepository(final String name, final Hashtable environment) throws RepositoryException {
        return new RmiSafeClientRepository(new ClientAdapterFactory()){

            @Override
            protected RemoteRepository getRemoteRepository() throws RemoteException {
                try {
                    Object value = new InitialContext(environment).lookup(name);
                    if (value instanceof RemoteRepository) {
                        return (RemoteRepository)value;
                    }
                    throw new RemoteException("The JNDI resource " + name + " is not a remote repository stub: " + value);
                }
                catch (NamingException e) {
                    throw new RemoteException("Failed to look up the JNDI resource " + name, e);
                }
            }
        };
    }

    private Repository getRmiRepository(final String name) throws RepositoryException {
        return new RmiSafeClientRepository(new ClientAdapterFactory()){

            @Override
            protected RemoteRepository getRemoteRepository() throws RemoteException {
                try {
                    Remote value = Naming.lookup(name);
                    if (value instanceof RemoteRepository) {
                        return (RemoteRepository)value;
                    }
                    throw new RemoteException("The RMI resource " + name + " is not a remote repository stub: " + value);
                }
                catch (NotBoundException e) {
                    throw new RemoteException("RMI resource " + name + " not found", e);
                }
                catch (MalformedURLException e) {
                    throw new RemoteException("Invalid RMI name: " + name, e);
                }
                catch (RemoteException e) {
                    throw new RemoteException("Failed to look up the RMI resource " + name, e);
                }
            }
        };
    }

    private static class RmiSafeClientRepository
    extends SafeClientRepository {
        public RmiSafeClientRepository(LocalAdapterFactory factory) {
            super(factory);
        }

        @Override
        protected RemoteRepository getRemoteRepository() throws RemoteException {
            return null;
        }
    }
}

