/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.profilestores.dflt;

import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.core.runtime.userprofile.UserProfileStore;

public class InMemoryUserProfileStore
implements UserProfileStore,
DebuggableWithTitle {
    private static final Map<String, UserProfile> profiles = new HashMap<String, UserProfile>();

    public boolean isFixturesInstalled() {
        return false;
    }

    public UserProfile getUserProfile(String name) {
        return profiles.get(name);
    }

    public void save(String name, UserProfile userProfile) {
        profiles.put(name, userProfile);
    }

    public void debugData(DebugBuilder debug) {
        for (String name : profiles.keySet()) {
            debug.appendln(name, (Object)profiles.get(name));
        }
    }

    public String debugTitle() {
        return "InMemoryUserProfileStore";
    }
}

