/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.mmverror;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;

public class MmvErrorPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final String ID_PAGE_TITLE = "pageTitle";
    private static final String ID_APPLICATION_NAME = "applicationName";
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject
    @Named(value="applicationCss")
    private String applicationCss;
    @Inject
    @Named(value="applicationJs")
    private String applicationJs;
    private static final String ID_ERROR = "error";
    private static final String ID_ERROR_MESSAGE = "errorMessage";

    public MmvErrorPage(Set<String> validationErrors) {
        this((IModel<List<String>>)Model.ofList((List)_Lists.newArrayList(validationErrors)));
    }

    public MmvErrorPage(IModel<List<String>> model) {
        super(model);
        this.addPageTitle();
        this.addApplicationName();
        this.addValidationErrors();
    }

    private IModel<List<String>> getModel() {
        return this.getDefaultModel();
    }

    private MarkupContainer addPageTitle() {
        return this.add(new Component[]{new Label(ID_PAGE_TITLE, (Serializable)((Object)this.applicationName))});
    }

    private void addApplicationName() {
        this.add(new Component[]{new Label(ID_APPLICATION_NAME, (Serializable)((Object)this.applicationName))});
    }

    private void addValidationErrors() {
        ListView<String> validationErrorsView = new ListView<String>(ID_ERROR, this.getModel()){

            protected void populateItem(ListItem<String> item) {
                String validationError = (String)item.getModelObject();
                item.add(new Component[]{new Label(MmvErrorPage.ID_ERROR_MESSAGE, (Serializable)((Object)validationError))});
            }
        };
        this.add(new Component[]{validationErrorsView});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        if (this.applicationCss != null) {
            response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)this.applicationCss));
        }
        if (this.applicationJs != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.applicationJs));
        }
    }

    public boolean isErrorPage() {
        return true;
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

