/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.zclip;

import de.agilecoders.wicket.jquery.util.Strings2;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindow;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindowForm;
import org.apache.isis.viewer.wicket.ui.components.widgets.zclip.SimpleClipboardModalWindowPanel;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ZeroClipboardPanel
extends PanelAbstract<ObjectAdapterModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_SUBSCRIBING_LINK = "subscribingLink";
    private static final String ID_COPY_LINK = "copyLink";
    private static final String ID_SIMPLE_CLIPBOARD_MODAL_WINDOW = "simpleClipboardModalWindow";
    private AjaxLink<ObjectAdapter> copyLink;
    private SimpleClipboardModalWindow simpleClipboardModalWindow;

    public ZeroClipboardPanel(String id, ObjectAdapterModel entityModel) {
        super(id, entityModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.copyLink == null) {
            this.copyLink = this.createLink(ID_COPY_LINK);
            this.addOrReplace(new Component[]{this.copyLink});
        }
        ObjectAdapterModel model = (ObjectAdapterModel)this.getModel();
        this.addSimpleClipboardModalWindow();
        EntityModel.RenderingHint renderingHint = model.getRenderingHint();
        EntityModel.Mode mode = model.getMode();
        this.setVisible(renderingHint == EntityModel.RenderingHint.REGULAR && mode == EntityModel.Mode.VIEW);
        this.setVisibilityAllowed(false);
    }

    private AjaxLink<ObjectAdapter> createLink(String linkId) {
        return this.newSimpleClipboardLink(linkId);
    }

    private AjaxLink<ObjectAdapter> newSimpleClipboardLink(String linkId) {
        return new AjaxLink<ObjectAdapter>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                String contentId = ZeroClipboardPanel.this.simpleClipboardModalWindow.getContentId();
                SimpleClipboardModalWindowPanel panel = new SimpleClipboardModalWindowPanel(contentId);
                SimpleClipboardModalWindowForm form = new SimpleClipboardModalWindowForm("form");
                TextField textField = new TextField("textField", (IModel)new LoadableDetachableModel<String>(){
                    private static final long serialVersionUID = 1L;

                    protected String load() {
                        Class pageClass = ZeroClipboardPanel.this.getPage().getPageClass();
                        ObjectAdapterModel entityModel = (ObjectAdapterModel)ZeroClipboardPanel.this.getModel();
                        PageParameters pageParameters = entityModel.getPageParameters();
                        CharSequence urlFor = this.getRequestCycle().urlFor(pageClass, pageParameters);
                        return this.getRequestCycle().getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlFor));
                    }
                });
                panel.add(new Component[]{form});
                form.add(new Component[]{textField});
                textField.setOutputMarkupId(true);
                CharSequence modalId = Strings2.escapeMarkupId((CharSequence)ZeroClipboardPanel.this.simpleClipboardModalWindow.getMarkupId());
                CharSequence textFieldId = Strings2.escapeMarkupId((CharSequence)textField.getMarkupId());
                target.appendJavaScript((CharSequence)String.format("$('#%s').one('shown.bs.modal', function(){Wicket.$('%s').select();});", modalId, textFieldId));
                ZeroClipboardPanel.this.simpleClipboardModalWindow.setPanel((Component)panel, target);
                ZeroClipboardPanel.this.simpleClipboardModalWindow.showPrompt(target);
                target.focusComponent((Component)textField);
            }
        };
    }

    private void addSimpleClipboardModalWindow() {
        this.simpleClipboardModalWindow = SimpleClipboardModalWindow.newModalWindow(ID_SIMPLE_CLIPBOARD_MODAL_WINDOW);
        this.addOrReplace(new Component[]{this.simpleClipboardModalWindow});
    }

    protected PageClassRegistry getPageClassRegistry() {
        PageClassRegistryAccessor pcra = (PageClassRegistryAccessor)this.getApplication();
        return pcra.getPageClassRegistry();
    }
}

