/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.themepicker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import de.agilecoders.wicket.themes.markup.html.bootstrap.BootstrapThemeTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchTheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchThemeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.IsisWicketThemeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisWicketThemeSupportDefault
implements IsisWicketThemeSupport {
    private static final Logger LOG = LoggerFactory.getLogger(IsisWicketThemeSupportDefault.class);
    private static final BootswatchTheme BOOTSWATCH_THEME_DEFAULT = BootswatchTheme.Flatly;
    private final _Lazy<ThemeProvider> themeProvider = _Lazy.of(this::createThemeProvider);

    @Override
    public ThemeProvider getThemeProvider() {
        return (ThemeProvider)this.themeProvider.get();
    }

    @Override
    public List<String> getEnabledThemeNames() {
        BootstrapThemeTheme bootstrapTheme = new BootstrapThemeTheme();
        List<BootswatchTheme> bootswatchThemes = Arrays.asList(BootswatchTheme.values());
        List<String> allThemes = new ArrayList<String>();
        allThemes.add(bootstrapTheme.name());
        for (ITheme iTheme : bootswatchThemes) {
            allThemes.add(iTheme.name());
        }
        allThemes = this.filterThemes(allThemes);
        return allThemes;
    }

    private ThemeProvider createThemeProvider() {
        BootswatchTheme bootswatchTheme;
        String themeName = this.getConfiguration().getString("isis.viewer.wicket.themes.initial", BOOTSWATCH_THEME_DEFAULT.name());
        try {
            bootswatchTheme = BootswatchTheme.valueOf((String)themeName);
        }
        catch (Exception ex) {
            bootswatchTheme = BOOTSWATCH_THEME_DEFAULT;
            LOG.warn("Did not recognise configured bootswatch theme '{}', defaulting to '{}'", (Object)themeName, (Object)bootswatchTheme);
        }
        return new BootswatchThemeProvider(bootswatchTheme);
    }

    private List<String> filterThemes(List<String> allThemes) {
        ArrayList enabledThemes;
        Object[] enabledThemesArray = this.getConfiguration().getList("isis.viewer.wicket.themes.enabled");
        if (enabledThemesArray.length > 0) {
            final Set enabledThemesSet = _NullSafe.stream((Object[])enabledThemesArray).collect(Collectors.toSet());
            Iterable enabled = Iterables.filter(allThemes, (Predicate)new Predicate<String>(){

                public boolean apply(String themeName) {
                    return enabledThemesSet.contains(themeName);
                }
            });
            enabledThemes = _Lists.newArrayList((Iterable)enabled);
        } else {
            enabledThemes = allThemes;
        }
        return enabledThemes;
    }

    private IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }
}

