/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.tree;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.resource.spi.IllegalStateException;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.tree.TreeAdapter;
import org.apache.isis.applib.tree.TreeNode;
import org.apache.isis.applib.tree.TreePath;
import org.apache.isis.applib.tree.TreeState;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.functions._Functions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.NestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.extensions.markup.html.repeater.tree.theme.WindowsTheme;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

class IsisToWicketTreeAdapter {
    IsisToWicketTreeAdapter() {
    }

    public static EntityTree adapt(String id, ValueModel valueModel) {
        return new EntityTree(id, IsisToWicketTreeAdapter.toITreeProvider((ModelAbstract<ObjectAdapter>)valueModel), IsisToWicketTreeAdapter.toIModelRepresentingCollapseExpandState((ModelAbstract<ObjectAdapter>)valueModel));
    }

    public static EntityTree adapt(String id, ScalarModel scalarModel) {
        return new EntityTree(id, IsisToWicketTreeAdapter.toITreeProvider((ModelAbstract<ObjectAdapter>)scalarModel), IsisToWicketTreeAdapter.toIModelRepresentingCollapseExpandState((ModelAbstract<ObjectAdapter>)scalarModel));
    }

    private static ITreeProvider<TreeModel> toITreeProvider(ModelAbstract<ObjectAdapter> model) {
        TreeNode treeNode = (TreeNode)((ObjectAdapter)model.getObject()).getPojo();
        Class treeAdapterClass = treeNode.getTreeAdapterClass();
        TreeModelTreeAdapter wrappingTreeAdapter = new TreeModelTreeAdapter(treeAdapterClass);
        return new TreeModelTreeProvider(wrappingTreeAdapter.wrap(treeNode.getValue(), treeNode.getPositionAsPath()), wrappingTreeAdapter);
    }

    private static TreeExpansionModel toIModelRepresentingCollapseExpandState(ModelAbstract<ObjectAdapter> model) {
        TreeNode treeNode = (TreeNode)((ObjectAdapter)model.getObject()).getPojo();
        TreeState treeState = treeNode.getTreeState();
        return TreeExpansionModel.of(treeState.getExpandedNodePaths());
    }

    private static class TreeExpansionModel
    implements IModel<Set<TreeModel>> {
        private static final long serialVersionUID = 648152234030889164L;
        private final Set<TreePath> expandedTreePaths;
        private final Set<TreeModel> expandedNodes;

        public static TreeExpansionModel of(Set<TreePath> expandedTreePaths) {
            return new TreeExpansionModel(expandedTreePaths);
        }

        public void onExpand(TreeModel t) {
            this.expandedTreePaths.add(t.getTreePath());
        }

        public void onCollapse(TreeModel t) {
            this.expandedTreePaths.remove(t.getTreePath());
        }

        public boolean contains(TreePath treePath) {
            return this.expandedTreePaths.contains(treePath);
        }

        private TreeExpansionModel(Set<TreePath> expandedTreePaths) {
            this.expandedTreePaths = expandedTreePaths;
            this.expandedNodes = expandedTreePaths.stream().map(tPath -> new TreeModel((TreePath)tPath)).collect(Collectors.toSet());
        }

        public Set<TreeModel> getObject() {
            return this.expandedNodes;
        }

        public String toString() {
            return "{" + this.expandedTreePaths.stream().map(Object::toString).collect(Collectors.joining(", ")) + "}";
        }
    }

    private static class LoadableDetachableTreeModel
    extends LoadableDetachableModel<TreeModel> {
        private static final long serialVersionUID = 1L;
        private final RootOid id;
        private final TreePath treePath;
        private final int hashCode;

        public LoadableDetachableTreeModel(TreeModel tModel) {
            super((Object)tModel);
            this.treePath = tModel.getTreePath();
            this.id = (RootOid)((ObjectAdapter)tModel.getObject()).getOid();
            this.hashCode = Objects.hash(this.id.hashCode(), this.treePath.hashCode());
        }

        protected TreeModel load() {
            PersistenceSession persistenceSession = (PersistenceSession)IsisContext.getPersistenceSession().orElseThrow(() -> new RuntimeException((Throwable)new IllegalStateException(String.format("Tree creation: missing a PersistenceSession to recreate TreeModel from Oid: '%s'", this.id))));
            ObjectAdapter objAdapter = persistenceSession.adapterFor(this.id);
            if (objAdapter == null) {
                throw new NoSuchElementException(String.format("Tree creation: could not recreate TreeModel from Oid: '%s'", this.id));
            }
            Object pojo = objAdapter.getPojo();
            if (pojo == null) {
                throw new NoSuchElementException(String.format("Tree creation: could not recreate Pojo from Oid: '%s'", this.id));
            }
            return new TreeModel(objAdapter, this.treePath);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LoadableDetachableTreeModel) {
                LoadableDetachableTreeModel other = (LoadableDetachableTreeModel)((Object)obj);
                return this.treePath.equals(other.treePath) && this.id.equals(other.id);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class TreeModelTreeProvider
    implements ITreeProvider<TreeModel> {
        private static final long serialVersionUID = 1L;
        private final TreeModel primaryValue;
        private final TreeModelTreeAdapter treeAdapter;

        private TreeModelTreeProvider(TreeModel primaryValue, TreeModelTreeAdapter treeAdapter) {
            this.primaryValue = primaryValue;
            this.treeAdapter = treeAdapter;
        }

        public void detach() {
        }

        public Iterator<? extends TreeModel> getRoots() {
            return _Lists.singleton((Object)((Object)this.primaryValue)).iterator();
        }

        public boolean hasChildren(TreeModel node) {
            return this.treeAdapter.childCountOf(node) > 0;
        }

        public Iterator<? extends TreeModel> getChildren(TreeModel node) {
            return this.treeAdapter.childrenOf(node).iterator();
        }

        public IModel<TreeModel> model(TreeModel treeModel) {
            return treeModel.isTreePathModelOnly() ? Model.of((Serializable)((Object)treeModel)) : new LoadableDetachableTreeModel(treeModel);
        }
    }

    private static class TreeModelTreeAdapter
    implements TreeAdapter<TreeModel>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<? extends TreeAdapter> treeAdapterClass;
        private transient TreeAdapter wrappedTreeAdapter;

        private TreeModelTreeAdapter(Class<? extends TreeAdapter> treeAdapterClass) {
            this.treeAdapterClass = treeAdapterClass;
        }

        private TreeAdapter wrappedTreeAdapter() {
            if (this.wrappedTreeAdapter != null) {
                return this.wrappedTreeAdapter;
            }
            try {
                FactoryService factoryService = (FactoryService)IsisContext.getServicesInjector().lookupServiceElseFail(FactoryService.class);
                this.wrappedTreeAdapter = (TreeAdapter)factoryService.instantiate(this.treeAdapterClass);
                return this.wrappedTreeAdapter;
            }
            catch (Exception e) {
                throw new RuntimeException("failed to instantiate tree adapter", e);
            }
        }

        public Optional<TreeModel> parentOf(TreeModel treeModel) {
            if (treeModel == null) {
                return Optional.empty();
            }
            return this.wrappedTreeAdapter().parentOf(this.unwrap(treeModel)).map(pojo -> this.wrap(pojo, treeModel.getTreePath().getParentIfAny()));
        }

        public int childCountOf(TreeModel treeModel) {
            if (treeModel == null) {
                return 0;
            }
            return this.wrappedTreeAdapter().childCountOf(this.unwrap(treeModel));
        }

        public Stream<TreeModel> childrenOf(TreeModel treeModel) {
            if (treeModel == null) {
                return Stream.empty();
            }
            return this.wrappedTreeAdapter().childrenOf(this.unwrap(treeModel)).map(this.newPojoToTreeModelMapper(treeModel));
        }

        private TreeModel wrap(Object pojo, TreePath treePath) {
            Objects.requireNonNull(pojo);
            return new TreeModel(this.persistenceSession().adapterFor(pojo), treePath);
        }

        private Object unwrap(TreeModel model) {
            Objects.requireNonNull(model);
            return ((ObjectAdapter)model.getObject()).getPojo();
        }

        private PersistenceSession persistenceSession() {
            return IsisContext.getPersistenceSession().orElse(null);
        }

        private Function<Object, TreeModel> newPojoToTreeModelMapper(TreeModel parent) {
            return _Functions.indexAwareToFunction((indexWithinSiblings, pojo) -> this.wrap(pojo, parent.getTreePath().append(indexWithinSiblings)));
        }
    }

    private static class TreeModel
    extends EntityModel {
        private static final long serialVersionUID = 8916044984628849300L;
        private final TreePath treePath;

        public TreeModel(TreePath treePath) {
            super((ObjectAdapter)null);
            this.treePath = treePath;
        }

        public TreeModel(ObjectAdapter adapter, TreePath treePath) {
            super(Objects.requireNonNull(adapter));
            this.treePath = treePath;
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public boolean isTreePathModelOnly() {
            return this.getObject() == null;
        }
    }

    private static class EntityTree
    extends NestedTree<TreeModel> {
        private static final long serialVersionUID = 1L;

        public EntityTree(String id, ITreeProvider<TreeModel> provider, TreeExpansionModel collapseExpandState) {
            super(id, provider, (IModel)collapseExpandState);
            this.add(new Behavior[]{new WindowsTheme()});
        }

        protected Component newContentComponent(String id, IModel<TreeModel> node) {
            TreeModel treeModel = (TreeModel)((Object)node.getObject());
            EntityIconAndTitlePanel entityIconAndTitle = new EntityIconAndTitlePanel(id, (ObjectAdapterModel)treeModel);
            return entityIconAndTitle;
        }

        public Component newNodeComponent(String id, IModel<TreeModel> model) {
            Node<TreeModel> node = new Node<TreeModel>(id, (AbstractTree)this, model){
                private static final long serialVersionUID = 1L;

                protected Component createContent(String id, IModel<TreeModel> model) {
                    return this.newContentComponent(id, model);
                }

                protected MarkupContainer createJunctionComponent(String id) {
                    final 1 node = this;
                    final Runnable toggleExpandCollapse = () -> (this).toggle();
                    return new AjaxFallbackLink<Void>(id){
                        private static final long serialVersionUID = 1L;

                        public void onClick(Optional<AjaxRequestTarget> target) {
                            toggleExpandCollapse.run();
                        }

                        public boolean isEnabled() {
                            return this.getProvider().hasChildren(node.getModelObject());
                        }

                        public boolean isEnabledInHierarchy() {
                            return true;
                        }
                    };
                }
            };
            node.setOutputMarkupId(true);
            return node;
        }

        public AbstractTree.State getState(TreeModel t) {
            TreeExpansionModel treeExpansionModel = (TreeExpansionModel)this.getModel();
            return treeExpansionModel.contains(t.getTreePath()) ? AbstractTree.State.EXPANDED : AbstractTree.State.COLLAPSED;
        }

        public void expand(TreeModel t) {
            TreeExpansionModel treeExpansionModel = (TreeExpansionModel)this.getModel();
            treeExpansionModel.onExpand(t);
            super.expand((Object)t);
        }

        public void collapse(TreeModel t) {
            TreeExpansionModel treeExpansionModel = (TreeExpansionModel)this.getModel();
            treeExpansionModel.onCollapse(t);
            super.collapse((Object)t);
        }
    }
}

