/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.primitive;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;
import java.io.Serializable;
import org.apache.isis.applib.annotation.LabelPosition;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanPanel
extends ScalarPanelAbstract2 {
    private static final long serialVersionUID = 1L;
    private CheckBoxX checkBox;

    public BooleanPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected MarkupContainer createComponentForRegular() {
        String name = ((ScalarModel)this.getModel()).getName();
        this.checkBox = this.createCheckBox("scalarValue", CheckBoxXConfig.Sizes.lg);
        this.checkBox.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup scalarIfRegularFormGroup = new FormGroup("scalarIfRegular", (FormComponent<?>)this.checkBox);
        scalarIfRegularFormGroup.add(new Component[]{this.checkBox});
        if (((ScalarModel)this.getModel()).isRequired() && ((ScalarModel)this.getModel()).isEnabled()) {
            scalarIfRegularFormGroup.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        String labelCaption = this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.checkBox);
        Label scalarName = this.createScalarName("scalarName", labelCaption);
        scalarIfRegularFormGroup.add(new Component[]{scalarName});
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            Tooltips.addTooltip((Component)scalarIfRegularFormGroup, describedAs);
        }
        return scalarIfRegularFormGroup;
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.checkBox;
    }

    @Override
    protected Component createComponentForCompact() {
        return this.createCheckBox("scalarIfCompact", CheckBoxXConfig.Sizes.sm);
    }

    @Override
    protected ScalarPanelAbstract2.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract2.InlinePromptConfig.supportedAndHide((Component)(this.scalarModel.getMode() == EntityModel.Mode.EDIT || this.scalarModel.hasActionWithInlineAsIfEdit() || this.scalarModel.getKind() == ScalarModel.Kind.PARAMETER ? this.checkBox : null));
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        return new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Boolean bool;
                ScalarModel model = (ScalarModel)BooleanPanel.this.getModel();
                ObjectAdapter adapter = (ObjectAdapter)model.getObject();
                Boolean bl = bool = adapter != null ? (Boolean)adapter.getPojo() : null;
                return bool == null ? "(not set)" : (bool != false ? "Yes" : "No");
            }
        };
    }

    private CheckBoxX createCheckBox(String id, CheckBoxXConfig.Sizes size) {
        final CheckBoxXConfig config = BooleanPanel.configFor(((ScalarModel)this.getModel()).isRequired(), size);
        CheckBoxX checkBox = new CheckBoxX(id, (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean getObject() {
                ScalarModel model = (ScalarModel)BooleanPanel.this.getModel();
                ObjectAdapter adapter = (ObjectAdapter)model.getObject();
                return adapter != null ? (Boolean)adapter.getPojo() : null;
            }

            public void setObject(Boolean object) {
                ObjectAdapter adapter = BooleanPanel.this.getPersistenceSession().adapterFor((Object)object);
                ((ScalarModel)BooleanPanel.this.getModel()).setObject(adapter);
            }
        }){
            private static final long serialVersionUID = 1L;

            public CheckBoxXConfig getConfig() {
                return config;
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("type", (CharSequence)"xx");
            }
        };
        checkBox.setOutputMarkupId(true);
        checkBox.setEnabled(false);
        ObjectSpecification objectSpecification = ((ScalarModel)this.getModel()).getTypeOfSpecification();
        if (objectSpecification.getFullIdentifier().equals("boolean") && ((ScalarModel)this.getModel()).getObject() == null) {
            ((ScalarModel)this.getModel()).setObject(this.getPersistenceSession().adapterFor((Object)false));
        }
        return checkBox;
    }

    private static CheckBoxXConfig configFor(boolean required, CheckBoxXConfig.Sizes size) {
        CheckBoxXConfig config = new CheckBoxXConfig(){
            private static final long serialVersionUID = 1L;
            {
                this.put((IKey)new Key("tabindex"), "0");
            }
        };
        return config.withSize(size).withEnclosedLabel(false).withIconChecked("<i class='fa fa-fw fa-check'></i>").withIconNull("<i class='fa fa-fw fa-square'></i>").withThreeState(!required);
    }

    @Override
    protected void onInitializeWhenEnabled() {
        super.onInitializeWhenEnabled();
        this.checkBox.setEnabled(true);
    }

    @Override
    protected void onInitializeWhenViewMode() {
        super.onInitializeWhenViewMode();
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void onInitializeWhenDisabled(String disableReason) {
        super.onInitializeWhenDisabled(disableReason);
        this.checkBox.setEnabled(false);
    }

    public String getVariation() {
        LabelAtFacet facet = (LabelAtFacet)((ScalarModel)this.getModel()).getFacet(LabelAtFacet.class);
        String variation = facet != null && LabelPosition.RIGHT == facet.label() ? "labelRightPosition" : super.getVariation();
        return variation;
    }

    @Override
    protected String getScalarPanelType() {
        return "booleanPanel";
    }
}

