/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

public class DateConverterForJodaDateTime
extends DateConverterForJodaAbstract<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJodaDateTime(WicketViewerSettings settings, int adjustBy) {
        super(DateTime.class, DateFormatSettings.ofDateAndTime(settings, adjustBy));
    }

    @Override
    protected DateTime minusDays(DateTime value, int adjustBy) {
        return value.minusDays(adjustBy);
    }

    @Override
    protected DateTime plusDays(DateTime value, int adjustBy) {
        return value.plusDays(adjustBy);
    }

    @Override
    protected DateTime convert(String value) throws ConversionException {
        try {
            return this.getFormatterForDateTimePattern().parseDateTime(value);
        }
        catch (IllegalArgumentException ex) {
            try {
                return this.getFormatterForDatePattern().parseDateTime(value);
            }
            catch (IllegalArgumentException ex2) {
                throw new ConversionException(String.format("Cannot convert '%s' into a date/time", value), (Throwable)ex2);
            }
        }
    }

    @Override
    protected String toString(DateTime value, DateTimeFormatter dateTimeFormatter) {
        return value.toString(dateTimeFormatter);
    }
}

