/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaAbstract;
import org.apache.wicket.util.convert.ConversionException;

public class DateConverterForJavaSqlTimestamp
extends DateConverterForJavaAbstract<Timestamp> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJavaSqlTimestamp(WicketViewerSettings settings, int adjustBy) {
        this(DateFormatSettings.ofDateAndTime(settings, adjustBy));
    }

    private DateConverterForJavaSqlTimestamp(DateFormatSettings dateFormatSettings) {
        super(Timestamp.class, dateFormatSettings);
    }

    @Override
    protected Timestamp doConvertToObject(String value, Locale locale) throws ConversionException {
        Timestamp date = (Timestamp)this.parseDateTime(value);
        Timestamp adjustedDate = (Timestamp)this.adjustDaysBackward(date);
        return adjustedDate;
    }

    @Override
    protected String doConvertToString(Timestamp value, Locale locale) throws ConversionException {
        Timestamp adjustedDate = (Timestamp)this.adjustDaysForward(value);
        return this.getDateTimeFormat().format(adjustedDate);
    }

    @Override
    protected Timestamp temporalValueOf(Date date) {
        return new Timestamp(date.getTime());
    }
}

