/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverterAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.wicket.util.convert.ConversionException;

public abstract class DateConverterForJavaAbstract<T extends Date>
extends DateConverterAbstract<T> {
    private static final long serialVersionUID = 1L;
    private transient SimpleDateFormat dateOnlyPattern;
    private transient SimpleDateFormat dateTimePattern;

    public DateConverterForJavaAbstract(Class<T> cls, DateFormatSettings dateFormatSettings) {
        super(cls, dateFormatSettings);
    }

    protected SimpleDateFormat getDateOnlyFormat() {
        if (this.dateOnlyPattern == null) {
            this.dateOnlyPattern = new SimpleDateFormat(this.dateFormatSettings.getDatePattern());
        }
        return this.dateOnlyPattern;
    }

    protected SimpleDateFormat getDateTimeFormat() {
        if (this.dateTimePattern == null) {
            this.dateTimePattern = new SimpleDateFormat(this.dateFormatSettings.getDateTimePattern());
        }
        return this.dateTimePattern;
    }

    protected <X extends Date> T adjustDaysForward(X value) {
        int days = this.dateFormatSettings.getAdjustBy();
        if (days == 0) {
            return this.temporalValueOf(value);
        }
        return this.temporalValueOf((Date)this.addDaysTo(value, days));
    }

    protected <X extends Date> T adjustDaysBackward(X value) {
        int days = this.dateFormatSettings.getAdjustBy();
        if (days == 0) {
            return this.temporalValueOf(value);
        }
        return this.temporalValueOf((Date)this.addDaysTo(value, -days));
    }

    protected T parseDateTime(String valueStr) {
        try {
            Date parsed = this.getDateTimeFormat().parse(valueStr);
            return this.temporalValueOf(parsed);
        }
        catch (ParseException ex) {
            try {
                Date parsed = this.getDateOnlyFormat().parse(valueStr);
                return this.temporalValueOf(parsed);
            }
            catch (ParseException ex2) {
                throw new ConversionException("Value cannot be converted as a date/time", (Throwable)ex);
            }
        }
    }

    protected T parseDateOnly(String valueStr) {
        try {
            Date parsed = this.getDateOnlyFormat().parse(valueStr);
            return this.temporalValueOf(parsed);
        }
        catch (ParseException e) {
            throw new ConversionException("Cannot convert into a date", (Throwable)e);
        }
    }

    protected abstract T temporalValueOf(Date var1);

    private final <X extends Date> T addDaysTo(X value, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.add(5, days);
        Date adjusted = cal.getTime();
        return this.temporalValueOf(adjusted);
    }
}

