/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdk8time;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdk8time.DateConverterForJdk8Abstract;
import org.apache.wicket.util.convert.ConversionException;

public class DateConverterForJdk8LocalDate
extends DateConverterForJdk8Abstract<LocalDate> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJdk8LocalDate(WicketViewerSettings settings, int adjustBy) {
        super(LocalDate.class, DateFormatSettings.ofDateOnly(settings, adjustBy));
    }

    @Override
    protected LocalDate minusDays(LocalDate value, int adjustBy) {
        return value.minusDays(adjustBy);
    }

    @Override
    protected LocalDate plusDays(LocalDate value, int adjustBy) {
        return value.plusDays(adjustBy);
    }

    @Override
    protected LocalDate convert(String value) throws ConversionException {
        try {
            return this.getFormatterForDateTimePattern8().parse((CharSequence)value, LocalDate::from);
        }
        catch (Exception ex) {
            throw new ConversionException(String.format("Cannot convert '%s' into a date/time", value), (Throwable)ex);
        }
    }

    @Override
    protected String toString(LocalDate value, DateTimeFormatter dateTimeFormatter) {
        return value.format(dateTimeFormatter);
    }
}

