/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdk8time;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverterAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.wicket.util.convert.ConversionException;

abstract class DateConverterForJdk8Abstract<T>
extends DateConverterAbstract<T> {
    private static final long serialVersionUID = 1L;

    DateConverterForJdk8Abstract(Class<T> cls, DateFormatSettings dateFormatSettings) {
        super(cls, dateFormatSettings);
    }

    @Override
    protected final T doConvertToObject(String value, Locale locale) {
        T dateTime = this.convert(value);
        return this.minusDays(dateTime, this.dateFormatSettings.getAdjustBy());
    }

    @Override
    protected String doConvertToString(T value, Locale locale) {
        T t = this.plusDays(value, this.dateFormatSettings.getAdjustBy());
        return this.toString(t, DateTimeFormatter.ofPattern(this.dateFormatSettings.getDateTimePattern()));
    }

    protected DateTimeFormatter getFormatterForDatePattern8() {
        return DateTimeFormatter.ofPattern(this.dateFormatSettings.getDatePattern());
    }

    protected DateTimeFormatter getFormatterForDateTimePattern8() {
        return DateTimeFormatter.ofPattern(this.dateFormatSettings.getDateTimePattern());
    }

    protected abstract T minusDays(T var1, int var2);

    protected abstract T plusDays(T var1, int var2);

    protected abstract T convert(String var1) throws ConversionException;

    protected abstract String toString(T var1, DateTimeFormatter var2);
}

