/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.Model;

public class TextFieldValueModel<T extends Serializable>
extends Model<T> {
    private static final long serialVersionUID = 1L;
    private final ScalarModelProvider scalarModelProvider;

    public TextFieldValueModel(ScalarModelProvider scalarModelProvider) {
        this.scalarModelProvider = scalarModelProvider;
    }

    public T getObject() {
        ScalarModel model = this.scalarModelProvider.getModel();
        ObjectAdapter objectAdapter = (ObjectAdapter)model.getObject();
        return this.asT(objectAdapter);
    }

    private T asT(ObjectAdapter objectAdapter) {
        return (T)((Serializable)(objectAdapter != null ? objectAdapter.getPojo() : null));
    }

    public void setObject(T object) {
        if (object == null) {
            this.scalarModelProvider.getModel().setObject(null);
        } else {
            ObjectAdapter objectAdapter = this.scalarModelProvider.getObjectAdapterProvider().adapterFor(object);
            this.scalarModelProvider.getModel().setObject(objectAdapter);
        }
    }

    public static interface ScalarModelProvider {
        public ScalarModel getModel();

        public ObjectAdapterProvider getObjectAdapterProvider();
    }
}

