/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public abstract class ScalarPanelTextFieldAbstract<T extends Serializable>
extends ScalarPanelAbstract2
implements TextFieldValueModel.ScalarModelProvider {
    private static final long serialVersionUID = 1L;
    protected final Class<T> cls;
    private AbstractTextComponent<T> textField;
    @Inject
    WicketViewerSettings settings;

    public ScalarPanelTextFieldAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel);
        this.cls = cls;
    }

    protected AbstractTextComponent<T> getTextField() {
        return this.textField;
    }

    protected AbstractTextComponent<T> createTextFieldForRegular(String id) {
        return this.createTextField(id);
    }

    protected TextField<T> createTextField(String id) {
        return new TextField(id, this.newTextFieldValueModel(), this.cls);
    }

    TextFieldValueModel<T> newTextFieldValueModel() {
        return new TextFieldValueModel(this);
    }

    @Override
    protected MarkupContainer createComponentForRegular() {
        this.textField = this.createTextFieldForRegular("scalarValue");
        this.textField.setOutputMarkupId(true);
        this.addStandardSemantics();
        MarkupContainer scalarIfRegularFormGroup = this.createScalarIfRegularFormGroup();
        return scalarIfRegularFormGroup;
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.textField;
    }

    private void addReplaceDisabledTagWithReadonlyTagBehaviourIfRequired(Component component) {
        if (!this.getSettings().isReplaceDisabledTagWithReadonlyTag()) {
            return;
        }
        if (component == null) {
            return;
        }
        if (!component.getBehaviors(ReplaceDisabledTagWithReadonlyTagBehaviour.class).isEmpty()) {
            return;
        }
        component.add(new Behavior[]{new ReplaceDisabledTagWithReadonlyTagBehaviour()});
    }

    protected MarkupContainer createScalarIfRegularFormGroup() {
        Fragment textFieldFragment = this.createTextFieldFragment("scalarValueContainer");
        String name = ((ScalarModel)this.getModel()).getName();
        this.textField.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup formGroup = new FormGroup("scalarIfRegular", (FormComponent<?>)this.textField);
        textFieldFragment.add(new Component[]{this.textField});
        formGroup.add(new Component[]{textFieldFragment});
        String labelCaption = this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.textField);
        Label scalarName = this.createScalarName("scalarName", labelCaption);
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            Tooltips.addTooltip((Component)scalarName, describedAs);
        }
        formGroup.add(new Component[]{scalarName});
        return formGroup;
    }

    private Fragment createTextFieldFragment(String id) {
        return new Fragment(id, this.createTextFieldFragmentId(), (MarkupContainer)this);
    }

    protected String createTextFieldFragmentId() {
        return "text";
    }

    @Override
    protected Component createInlinePromptComponent(String id, IModel<String> inlinePromptModel) {
        Fragment fragment = new Fragment(id, "textInlinePrompt", (MarkupContainer)this){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
        Label label = new Label("scalarValue", inlinePromptModel);
        fragment.add(new Component[]{label});
        return fragment;
    }

    protected void addStandardSemantics() {
        this.textField.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.setTextFieldSizeAndMaxLengthIfSpecified();
        this.addValidatorForIsisValidation();
    }

    private void addValidatorForIsisValidation() {
        final ScalarModel scalarModel = (ScalarModel)this.getModel();
        this.textField.add(new IValidator<T>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<T> validatable) {
                Serializable proposedValue = (Serializable)validatable.getValue();
                ObjectAdapter proposedAdapter = ScalarPanelTextFieldAbstract.this.getPersistenceSession().adapterFor((Object)proposedValue);
                String reasonIfAny = scalarModel.validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }
        });
    }

    private void setTextFieldSizeAndMaxLengthIfSpecified() {
        Integer maxLength = ScalarPanelTextFieldAbstract.getValueOf((ScalarModel)this.getModel(), MaxLengthFacet.class);
        Integer typicalLength = ScalarPanelTextFieldAbstract.getValueOf((ScalarModel)this.getModel(), TypicalLengthFacet.class);
        if (typicalLength != null && maxLength != null && typicalLength > maxLength) {
            typicalLength = maxLength;
        }
        if (typicalLength != null) {
            this.textField.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + typicalLength))))});
        }
        if (maxLength != null) {
            this.textField.add(new Behavior[]{new AttributeModifier("maxlength", (IModel)Model.of((Serializable)((Object)("" + maxLength))))});
        }
    }

    @Override
    protected Component createComponentForCompact() {
        Fragment compactFragment = this.getCompactFragment(CompactType.SPAN);
        Label labelIfCompact = new Label("scalarIfCompact", (Serializable)((Object)((ScalarModel)this.getModel()).getObjectAsString()));
        compactFragment.add(new Component[]{labelIfCompact});
        return labelIfCompact;
    }

    Fragment getCompactFragment(CompactType type) {
        Fragment compactFragment;
        switch (type) {
            case INPUT_CHECKBOX: {
                compactFragment = new Fragment("scalarIfCompact", "compactAsInputCheckbox", (MarkupContainer)this);
                break;
            }
            default: {
                compactFragment = new Fragment("scalarIfCompact", "compactAsSpan", (MarkupContainer)this);
            }
        }
        return compactFragment;
    }

    @Override
    protected ScalarPanelAbstract2.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract2.InlinePromptConfig.supportedAndHide(this.textField);
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        IModel model = this.textField.getModel();
        return (IModel)_Casts.uncheckedCast((Object)model);
    }

    @Override
    protected void onInitializeWhenViewMode() {
        super.onInitializeWhenViewMode();
        this.textField.setEnabled(false);
        this.addReplaceDisabledTagWithReadonlyTagBehaviourIfRequired((Component)this.textField);
        this.clearTooltip();
    }

    @Override
    protected void onInitializeWhenDisabled(String disableReason) {
        super.onInitializeWhenDisabled(disableReason);
        this.textField.setEnabled(false);
        this.addReplaceDisabledTagWithReadonlyTagBehaviourIfRequired((Component)this.textField);
        this.inlinePromptLink.setEnabled(false);
        this.setTooltip(disableReason);
    }

    @Override
    protected void onInitializeWhenEnabled() {
        super.onInitializeWhenEnabled();
        this.textField.setEnabled(true);
        this.inlinePromptLink.setEnabled(true);
        this.clearTooltip();
    }

    private void setTooltip(String tooltip) {
        Tooltips.addTooltip(this.textField, tooltip);
        Tooltips.addTooltip((Component)this.inlinePromptLink, tooltip);
    }

    private void clearTooltip() {
        Tooltips.clearTooltip(this.textField);
        Tooltips.clearTooltip((Component)this.inlinePromptLink);
    }

    private static Integer getValueOf(ScalarModel model, Class<? extends SingleIntValueFacet> facetType) {
        SingleIntValueFacet facet = (SingleIntValueFacet)model.getFacet(facetType);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }

    @Override
    protected WicketViewerSettings getSettings() {
        return this.settings;
    }

    @Override
    public ObjectAdapterProvider getObjectAdapterProvider() {
        return this.getPersistenceSession();
    }

    public static enum CompactType {
        INPUT_CHECKBOX,
        SPAN;

    }

    protected static class ReplaceDisabledTagWithReadonlyTagBehaviour
    extends Behavior {
        private static final long serialVersionUID = 1L;

        protected ReplaceDisabledTagWithReadonlyTagBehaviour() {
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            if (component.isEnabled()) {
                return;
            }
            tag.remove("disabled");
            tag.put("readonly", (CharSequence)"readonly");
        }
    }
}

