/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForChoices;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.wicketstuff.select2.ChoiceProvider;

public abstract class ScalarPanelSelect2Abstract
extends ScalarPanelAbstract2 {
    private static final long serialVersionUID = 1L;
    protected Select2 select2;

    public ScalarPanelSelect2Abstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    protected Select2 createSelect2(String id) {
        Select2 select2 = Select2.createSelect2(id, this.scalarModel);
        this.setProviderAndCurrAndPending(select2, this.scalarModel.getActionArgsHint());
        select2.setRequired(this.scalarModel.isRequired());
        return select2;
    }

    protected FormGroup createFormGroupAndName(FormComponent<?> component, String formGroupId, String nameId) {
        FormGroup formGroup = new FormGroup(formGroupId, component);
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        formGroup.add(new Component[]{component});
        String labelCaption = this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.select2.component());
        Label scalarName = this.createScalarName(nameId, labelCaption);
        if (describedAs != null) {
            Tooltips.addTooltip((Component)scalarName, describedAs);
        }
        formGroup.addOrReplace(new Component[]{scalarName});
        return formGroup;
    }

    protected FormGroup createFormGroup(FormComponent<?> formComponent) {
        this.setOutputMarkupId(true);
        this.select2.component().setOutputMarkupId(true);
        String name = this.scalarModel.getName();
        this.select2.setLabel((Model<String>)Model.of((Serializable)((Object)name)));
        FormGroup formGroup = this.createFormGroupAndName(formComponent, "scalarIfRegular", "scalarName");
        this.addStandardSemantics();
        ScalarModel model = (ScalarModel)this.getModel();
        if (model.isRequired() && model.isEnabled()) {
            formGroup.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        return formGroup;
    }

    protected void addStandardSemantics() {
        this.select2.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.select2.add(new Select2Validator(this.scalarModel));
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.select2.component();
    }

    private void setProviderAndCurrAndPending(Select2 select2, ObjectAdapter[] argsIfAvailable) {
        ChoiceProvider<ObjectAdapterMemento> choiceProvider = this.buildChoiceProvider(argsIfAvailable);
        select2.setProvider(choiceProvider);
        ((ScalarModel)this.getModel()).clearPending();
        if (choiceProvider instanceof ObjectAdapterMementoProviderForChoices) {
            ObjectAdapterMementoProviderForChoices providerForChoices = (ObjectAdapterMementoProviderForChoices)choiceProvider;
            this.syncIfNull(select2, providerForChoices.getChoiceMementos());
        }
    }

    protected abstract ChoiceProvider<ObjectAdapterMemento> buildChoiceProvider(ObjectAdapter[] var1);

    protected abstract void syncIfNull(Select2 var1, List<ObjectAdapterMemento> var2);

    @Override
    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("Wicket.Event.publish(Isis.Topic.OPEN_SELECT2, '%s')", inlinePromptForm.getMarkupId()));
    }

    public boolean updateChoices(ObjectAdapter[] argsIfAvailable) {
        if (this.select2 == null) {
            return false;
        }
        this.setProviderAndCurrAndPending(this.select2, argsIfAvailable);
        return true;
    }

    @Override
    public void repaint(AjaxRequestTarget target) {
        target.add(new Component[]{this.select2.component()});
    }

    static class Select2Validator
    implements IValidator<Object> {
        private static final long serialVersionUID = 1L;
        private final ScalarModel scalarModel;

        public Select2Validator(ScalarModel scalarModel) {
            this.scalarModel = scalarModel;
        }

        public void validate(IValidatable<Object> validatable) {
            ObjectAdapterMemento proposedValue;
            Object proposedValueObj = validatable.getValue();
            if (proposedValueObj instanceof List) {
                List proposedValueObjAsList = (List)proposedValueObj;
                if (proposedValueObjAsList.isEmpty()) {
                    return;
                }
                ObjectAdapterMemento oam = (ObjectAdapterMemento)proposedValueObjAsList.get(0);
                ObjectSpecId objectSpecId = oam.getObjectSpecId();
                proposedValue = ObjectAdapterMemento.createForList((Collection)proposedValueObjAsList, (ObjectSpecId)objectSpecId);
            } else {
                proposedValue = (ObjectAdapterMemento)proposedValueObj;
            }
            ObjectAdapter proposedAdapter = proposedValue.getObjectAdapter(ConcurrencyChecking.NO_CHECK, this.getPersistenceSession(), this.getSpecificationLoader());
            String reasonIfAny = this.scalarModel.validate(proposedAdapter);
            if (reasonIfAny != null) {
                ValidationError error = new ValidationError();
                error.setMessage(reasonIfAny);
                validatable.error((IValidationError)error);
            }
        }

        PersistenceSession getPersistenceSession() {
            return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
        }

        SpecificationLoader getSpecificationLoader() {
            return this.getIsisSessionFactory().getSpecificationLoader();
        }

        IsisSessionFactory getIsisSessionFactory() {
            return IsisContext.getSessionFactory();
        }
    }
}

