/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.util.Locale;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateFormatSettings;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class DateConverterAbstract<T>
implements DateConverter<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> cls;
    protected final DateFormatSettings dateFormatSettings;

    protected DateConverterAbstract(Class<T> cls, DateFormatSettings dateFormatSettings) {
        this.cls = cls;
        this.dateFormatSettings = dateFormatSettings;
    }

    @Override
    public Class<T> getConvertableClass() {
        return this.cls;
    }

    @Override
    public String getDatePattern(Locale locale) {
        return this.dateFormatSettings.getDatePattern();
    }

    @Override
    public String getDateTimePattern(Locale locale) {
        return this.dateFormatSettings.getDateTimePattern();
    }

    protected DateTimeFormatter getFormatterForDatePattern() {
        return DateTimeFormat.forPattern((String)this.dateFormatSettings.getDatePattern());
    }

    protected DateTimeFormatter getFormatterForDateTimePattern() {
        return DateTimeFormat.forPattern((String)this.dateFormatSettings.getDateTimePattern());
    }

    public T convertToObject(String value, Locale locale) throws ConversionException {
        return value != null ? (T)this.doConvertToObject(value, locale) : null;
    }

    public String convertToString(T value, Locale locale) {
        return value != null ? this.doConvertToString(value, locale) : null;
    }

    protected abstract T doConvertToObject(String var1, Locale var2) throws ConversionException;

    protected abstract String doConvertToString(T var1, Locale var2);
}

