/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.fieldset;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelUtil;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract2;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

public class PropertyGroup
extends PanelAbstract<EntityModel>
implements HasDynamicallyVisibleContent {
    private static final String ID_MEMBER_GROUP = "memberGroup";
    private static final String ID_MEMBER_GROUP_NAME = "memberGroupName";
    private static final String ID_ASSOCIATED_ACTION_LINKS_PANEL = "associatedActionLinksPanel";
    private static final String ID_ASSOCIATED_ACTION_LINKS_PANEL_DROPDOWN = "associatedActionLinksPanelDropDown";
    private static final String ID_PROPERTIES = "properties";
    private static final String ID_PROPERTY = "property";
    private final FieldSet fieldSet;
    private final boolean visible;
    private final List<ScalarPanelAbstract2> childScalarPanelAbstract2s;
    private final List<Component> childComponents;

    public PropertyGroup(String id, EntityModel model, FieldSet fieldSet) {
        super(id, model);
        this.fieldSet = fieldSet;
        this.childComponents = this.buildGui();
        this.childScalarPanelAbstract2s = FluentIterable.from(this.childComponents).filter(ScalarPanelAbstract2.class).toList();
        ImmutableList<ObjectAssociation> associations = this.getObjectAssociations();
        this.visible = !associations.isEmpty();
    }

    @Override
    public EntityModel getModel() {
        return (EntityModel)this.getDefaultModel();
    }

    private List<Component> buildGui() {
        ArrayList childComponents = _Lists.newArrayList();
        this.setOutputMarkupPlaceholderTag(true);
        this.setOutputMarkupId(true);
        WebMarkupContainer div = new WebMarkupContainer(ID_MEMBER_GROUP);
        String groupName = this.fieldSet.getName();
        ImmutableList<ObjectAssociation> associations = this.getObjectAssociations();
        ArrayList memberGroupActions = _Lists.newArrayList();
        RepeatingView propertyRv = new RepeatingView(ID_PROPERTIES);
        div.addOrReplace(new Component[]{propertyRv});
        for (ObjectAssociation association : associations) {
            WebMarkupContainer propertyRvContainer = new WebMarkupContainer(propertyRv.newChildId());
            propertyRv.addOrReplace(new Component[]{propertyRvContainer});
            Component component = this.addPropertyToForm(this.getModel(), (OneToOneAssociation)association, propertyRvContainer, memberGroupActions);
            childComponents.add(component);
        }
        WebMarkupContainer panelHeading = new WebMarkupContainer("panelHeading");
        div.addOrReplace(new Component[]{panelHeading});
        if (_Strings.isNullOrEmpty((CharSequence)groupName)) {
            panelHeading.setVisibilityAllowed(false);
        } else {
            panelHeading.addOrReplace(new Component[]{new Label(ID_MEMBER_GROUP_NAME, (Serializable)((Object)groupName))});
            List actionsPanel = LinkAndLabel.positioned((List)memberGroupActions, (ActionLayout.Position)ActionLayout.Position.PANEL);
            List actionsPanelDropDown = LinkAndLabel.positioned((List)memberGroupActions, (ActionLayout.Position)ActionLayout.Position.PANEL_DROPDOWN);
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)panelHeading, ID_ASSOCIATED_ACTION_LINKS_PANEL, actionsPanel, AdditionalLinksPanel.Style.INLINE_LIST);
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)panelHeading, ID_ASSOCIATED_ACTION_LINKS_PANEL_DROPDOWN, actionsPanelDropDown, AdditionalLinksPanel.Style.DROPDOWN);
        }
        if (associations.isEmpty()) {
            Components.permanentlyHide((MarkupContainer)this, div.getId());
        } else {
            this.addOrReplace(new Component[]{div});
        }
        return childComponents;
    }

    private ImmutableList<ObjectAssociation> getObjectAssociations() {
        List properties = this.fieldSet.getProperties();
        ObjectAdapter adapter = this.getModel().load(ConcurrencyChecking.NO_CHECK);
        return this.getObjectAssociations(properties, adapter);
    }

    private ImmutableList<ObjectAssociation> getObjectAssociations(List<PropertyLayoutData> properties, ObjectAdapter adapter) {
        return FluentIterable.from(properties).filter(propertyLayoutData -> propertyLayoutData.getMetadataError() == null).transform(propertyLayoutData -> {
            ObjectSpecification adapterSpecification = adapter.getSpecification();
            try {
                return adapterSpecification.getAssociation(propertyLayoutData.getId());
            }
            catch (ObjectSpecificationException e) {
                return null;
            }
        }).filter(objectAssociation -> {
            if (objectAssociation == null) {
                return false;
            }
            HiddenFacet facet = (HiddenFacet)objectAssociation.getFacet(HiddenFacet.class);
            return facet == null || facet.isNoop() || facet.where() != Where.EVERYWHERE && facet.where() != Where.OBJECT_FORMS;
        }).toList();
    }

    private Component addPropertyToForm(EntityModel entityModel, OneToOneAssociation otoa, WebMarkupContainer container, List<LinkAndLabel> entityActions) {
        PropertyMemento pm = new PropertyMemento(otoa, entityModel.getIsisSessionFactory());
        ScalarModel scalarModel = entityModel.getPropertyModel(pm, EntityModel.Mode.VIEW, EntityModel.RenderingHint.REGULAR);
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ID_PROPERTY, ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarModel);
        ObjectAdapter adapter = entityModel.load(ConcurrencyChecking.NO_CHECK);
        List associatedActions = ObjectAction.Util.findForAssociation((ObjectAdapter)adapter, (ObjectAssociation)otoa);
        entityActions.addAll(LinkAndLabelUtil.asActionLinksForAdditionalLinksPanel(entityModel, associatedActions, null));
        return component;
    }

    public void onConfigure() {
        for (ScalarPanelAbstract2 childComponent : this.childScalarPanelAbstract2s) {
            childComponent.configure();
        }
        super.onConfigure();
    }

    @Override
    public boolean isVisible() {
        if (this.childComponents.size() > this.childScalarPanelAbstract2s.size()) {
            return true;
        }
        for (ScalarPanelAbstract2 childComponent : this.childScalarPanelAbstract2s) {
            if (!childComponent.isVisibilityAllowed()) continue;
            return true;
        }
        return false;
    }
}

