/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns;

import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.columns.ColumnAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public final class ObjectAdapterPropertyColumn
extends ColumnAbstract<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel.Type type;
    private final String propertyExpression;
    private final boolean escaped;
    private final String parentTypeName;
    private final String describedAs;

    public ObjectAdapterPropertyColumn(EntityCollectionModel.Type type, IModel<String> columnNameModel, String sortProperty, String propertyName, boolean escaped, String parentTypeName, String describedAs) {
        super(columnNameModel, sortProperty);
        this.type = type;
        this.propertyExpression = propertyName;
        this.escaped = escaped;
        this.parentTypeName = parentTypeName;
        this.describedAs = describedAs;
    }

    public Component getHeader(String componentId) {
        Label label = new Label(componentId, this.getDisplayModel());
        label.setEscapeModelStrings(this.escaped);
        if (this.describedAs != null) {
            Tooltips.addTooltip((Component)label, this.describedAs);
        }
        return label;
    }

    public String getCssClass() {
        String cssClass = super.getCssClass();
        return (!_Strings.isNullOrEmpty((CharSequence)cssClass) ? cssClass + " " : "") + CssClassAppender.asCssStyle("isis-" + this.parentTypeName.replace(".", "-") + "-" + this.propertyExpression);
    }

    public void populateItem(Item<ICellPopulator<ObjectAdapter>> cellItem, String componentId, IModel<ObjectAdapter> rowModel) {
        Component component = this.createComponent(componentId, rowModel);
        cellItem.add(new Component[]{component});
    }

    private Component createComponent(String id, IModel<ObjectAdapter> rowModel) {
        ObjectAdapter adapter = (ObjectAdapter)rowModel.getObject();
        EntityModel entityModel = new EntityModel(adapter);
        OneToOneAssociation property = (OneToOneAssociation)adapter.getSpecification().getAssociation(this.propertyExpression);
        PropertyMemento pm = new PropertyMemento(property, entityModel.getIsisSessionFactory());
        ScalarModel scalarModel = entityModel.getPropertyModel(pm, EntityModel.Mode.VIEW, this.type.renderingHint());
        ComponentFactory componentFactory = this.findComponentFactory(ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)scalarModel);
        return componentFactory.createComponent(id, (IModel<?>)scalarModel);
    }
}

