/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;

public class AssociatedWithActionsHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityCollectionModel collectionModel;

    public AssociatedWithActionsHelper(EntityCollectionModel collectionModel) {
        this.collectionModel = collectionModel;
    }

    public List<ObjectAction> getAssociatedActions(IsisSessionFactory isisSessionFactory) {
        if (this.collectionModel.isStandalone()) {
            return Collections.emptyList();
        }
        OneToManyAssociation collection = this.collectionModel.getCollectionMemento().getCollection(isisSessionFactory.getSpecificationLoader());
        ObjectSpecification objectSpec = this.getObjectSpecification(isisSessionFactory);
        List<ActionType> actionTypes = AssociatedWithActionsHelper.inferActionTypes();
        Stream objectActions = objectSpec.streamObjectActions(actionTypes, Contributed.INCLUDED);
        return objectActions.filter(ObjectAction.Predicates.associatedWithAndWithCollectionParameterFor((OneToManyAssociation)collection)).collect(Collectors.toList());
    }

    private ObjectSpecification getObjectSpecification(IsisSessionFactory isisSessionFactory) {
        ObjectAdapterMemento parentOam = this.collectionModel.getParentObjectAdapterMemento();
        ObjectAdapter parentAdapter = parentOam.getObjectAdapter(ConcurrencyChecking.NO_CHECK, isisSessionFactory.getCurrentSession().getPersistenceSession(), isisSessionFactory.getSpecificationLoader());
        return parentAdapter.getSpecification();
    }

    private static List<ActionType> inferActionTypes() {
        ArrayList actionTypes = _Lists.newArrayList();
        actionTypes.add(ActionType.USER);
        if (_Context.isPrototyping()) {
            actionTypes.add(ActionType.PROTOTYPE);
        }
        return actionTypes;
    }
}

