/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseType;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorStrategy;
import org.apache.wicket.ajax.AjaxRequestTarget;

public class ActionFormExecutorStrategy
implements FormExecutorStrategy<ActionModel> {
    private final ActionModel model;
    private ActionPrompt actionPrompt;

    public ActionFormExecutorStrategy(ActionModel actionModel) {
        this.model = actionModel;
    }

    @Override
    public ActionModel getModel() {
        return this.model;
    }

    @Override
    public ObjectAdapter obtainTargetAdapter() {
        return this.model.getTargetAdapter();
    }

    @Override
    public String getReasonInvalidIfAny() {
        return this.model.getReasonInvalidIfAny();
    }

    @Override
    public void onExecuteAndProcessResults(AjaxRequestTarget target) {
        if (this.model.isBookmarkable()) {
            // empty if block
        }
        if (this.actionPrompt != null) {
            this.actionPrompt.closePrompt(target);
            this.model.clearArguments();
        }
    }

    @Override
    public ObjectAdapter obtainResultAdapter() {
        return this.model.execute();
    }

    @Override
    public void redirectTo(ObjectAdapter resultAdapter, AjaxRequestTarget targetIfany) {
        ActionResultResponse resultResponse = ActionResultResponseType.determineAndInterpretResult(this.model, targetIfany, resultAdapter);
        resultResponse.getHandlingStrategy().handleResults(resultResponse, this.getIsisSessionFactory());
    }

    void setActionPrompt(ActionPrompt actionPrompt) {
        this.actionPrompt = actionPrompt;
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

