/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.button.DropdownAutoOpenJavaScriptReference;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionUtil;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class ServiceActionsPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public ServiceActionsPanel(String id, List<CssMenuItem> menuItems) {
        super(id);
        ListView<CssMenuItem> menuItemsView = new ListView<CssMenuItem>("menuItems", menuItems){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<CssMenuItem> listItem) {
                CssMenuItem menuItem = (CssMenuItem)listItem.getModelObject();
                listItem.add(new Component[]{new Label("name", (Serializable)((Object)menuItem.getName()))});
                WebMarkupContainer topMenu = new WebMarkupContainer("topMenu");
                topMenu.add(new Behavior[]{new CssClassAppender("top-menu-" + CssClassAppender.asCssStyle(menuItem.getName()))});
                listItem.add(new Component[]{topMenu});
                List<CssMenuItem> subMenuItems = ServiceActionUtil.withSeparators(menuItem);
                ListView<CssMenuItem> subMenuItemsView = new ListView<CssMenuItem>("subMenuItems", subMenuItems){
                    private static final long serialVersionUID = 1L;

                    protected void populateItem(ListItem<CssMenuItem> listItem) {
                        CssMenuItem subMenuItem = (CssMenuItem)listItem.getModelObject();
                        if (subMenuItem.hasSubMenuItems()) {
                            ServiceActionsPanel.this.addFolderItem(subMenuItem, (ListItem<CssMenuItem>)listItem);
                        } else {
                            ServiceActionsPanel parent = ServiceActionsPanel.this;
                            ServiceActionUtil.addLeafItem(subMenuItem, listItem, (MarkupContainer)parent);
                        }
                    }
                };
                List<CssMenuItem> childItems = menuItem.getSubMenuItems();
                String cssForServices = _NullSafe.stream(childItems).map(input -> {
                    String actionIdentifier = input.getActionIdentifier();
                    if (actionIdentifier != null) {
                        String actionId = CssClassAppender.asCssStyle(actionIdentifier);
                        int i = actionId.lastIndexOf("-");
                        return i == -1 ? actionId : actionId.substring(0, i);
                    }
                    return null;
                }).filter(input -> input != null).map(input -> "isis-" + input).distinct().collect(Collectors.joining(" "));
                listItem.add(new Behavior[]{new CssClassAppender(cssForServices)});
                topMenu.add(new Component[]{subMenuItemsView});
            }
        };
        this.add(new Component[]{menuItemsView});
    }

    private void addFolderItem(CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem) {
        ServiceActionsPanel parent = this;
        ServiceActionUtil.addFolderItem(subMenuItem, listItem, (MarkupContainer)parent, ServiceActionUtil.SeparatorStrategy.WITH_SEPARATORS);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(ServiceActionsPanel.class, "ServiceActionsPanel.css")));
        Tooltips.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)DropdownAutoOpenJavaScriptReference.instance()));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"$('.dropdown-toggle').dropdownHover();"));
    }
}

