/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.app.registry;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;

public interface ComponentFactoryRegistrar {
    public void addComponentFactories(ComponentFactoryList var1);

    public static class ComponentFactoryList
    implements Iterable<ComponentFactory> {
        private final List<ComponentFactory> componentFactories = _Lists.newArrayList();

        public void add(ComponentFactory componentFactory) {
            this.componentFactories.add(componentFactory);
        }

        public void replace(ComponentFactory replacementComponentFactory) {
            this.removeExisting(ComponentFactoryList.matching(replacementComponentFactory.getComponentType()));
            this.add(replacementComponentFactory);
        }

        public void replace(Class<? extends ComponentFactory> toReplace, ComponentFactory replacementComponentFactory) {
            int indexOfOldFactory = this.removeExisting(ComponentFactoryList.matching(toReplace));
            this.insert(indexOfOldFactory, replacementComponentFactory);
        }

        private void insert(int indexToInsertInto, ComponentFactory replacementComponentFactory) {
            if (indexToInsertInto > -1 && indexToInsertInto < this.componentFactories.size()) {
                this.componentFactories.add(indexToInsertInto, replacementComponentFactory);
            } else {
                this.componentFactories.add(replacementComponentFactory);
            }
        }

        private int removeExisting(Predicate<ComponentFactory> predicate) {
            int indexOfFirst = -1;
            for (int i = 0; i < this.componentFactories.size(); ++i) {
                ComponentFactory factory = this.componentFactories.get(i);
                if (!predicate.apply((Object)factory)) continue;
                this.componentFactories.remove(i);
                if (indexOfFirst == -1) {
                    indexOfFirst = i;
                }
                --i;
            }
            return indexOfFirst;
        }

        private static Predicate<ComponentFactory> matching(final ComponentType componentType) {
            return new Predicate<ComponentFactory>(){

                public boolean apply(ComponentFactory input) {
                    return input.getComponentType() == componentType;
                }
            };
        }

        private static Predicate<ComponentFactory> matching(final Class<? extends ComponentFactory> toReplace) {
            return new Predicate<ComponentFactory>(){

                public boolean apply(ComponentFactory input) {
                    return toReplace.isAssignableFrom(input.getClass());
                }
            };
        }

        @Override
        public Iterator<ComponentFactory> iterator() {
            return this.componentFactories.iterator();
        }
    }
}

