/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.wicket;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.viewer.IsisWicketApplication;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.select2.Select2Choice;
import org.wicketstuff.select2.Select2MultiChoice;

public class LocalizerForIsis
extends Localizer {
    public String getString(String key, Component component, IModel<?> model, Locale locale, String style, IModel<String> defaultValue) throws MissingResourceException {
        String translated = this.translate(key, component);
        if (!_Strings.isNullOrEmpty((CharSequence)translated) && !translated.equals(key)) {
            return translated;
        }
        return super.getString(key, component, model, locale, style, defaultValue);
    }

    protected String translate(final String key, Component component) {
        Class<?> contextClass = this.determineContextClassElse(component, IsisWicketApplication.class);
        final String context = contextClass.getName();
        if (this.getIsisSessionFactory().inSession()) {
            return this.translate(key, context);
        }
        return (String)this.getIsisSessionFactory().doInSession((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return LocalizerForIsis.this.translate(key, context);
            }
        });
    }

    private Class<?> determineContextClassElse(Component component, Class<?> fallback) {
        return component != null ? this.determineContextClass(component) : fallback;
    }

    private Class<?> determineContextClass(Component component) {
        if (component instanceof Select2Choice || component instanceof Select2MultiChoice) {
            return component.getClass();
        }
        Component parentComponent = this.pageElseSignificantParentOf(component);
        return this.enclosing(parentComponent.getClass());
    }

    private Component pageElseSignificantParentOf(Component component) {
        Component page = this.pageOf(component);
        if (page != null) {
            return page;
        }
        return this.parentFormOrPanelOf(component);
    }

    private Component pageOf(Component component) {
        if (component instanceof Page) {
            return component;
        }
        MarkupContainer parent = component.getParent();
        if (parent != null) {
            return this.pageOf((Component)parent);
        }
        return component;
    }

    private Component parentFormOrPanelOf(Component component) {
        if (component instanceof Form || component instanceof Panel) {
            return component;
        }
        MarkupContainer parent = component.getParent();
        if (parent != null) {
            return this.parentFormOrPanelOf((Component)parent);
        }
        return parent;
    }

    private Class<?> enclosing(Class<?> cls) {
        Class<?> enclosingClass = cls.getEnclosingClass();
        return enclosingClass != null ? this.enclosing(enclosingClass) : cls;
    }

    private String translate(String key, String context) {
        TranslationService translationService = this.getTranslationService();
        return translationService.translate(context, key);
    }

    protected TranslationService getTranslationService() {
        return this.getServicesInjector().lookupService(TranslationService.class).orElse(null);
    }

    protected ServicesInjector getServicesInjector() {
        return this.getIsisSessionFactory().getServicesInjector();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

